/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.reducers.ComposerStateReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ConversationPartsReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ErrorReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.HeaderReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.ComposerUiState;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.m5.conversation.states.ConversationUiState;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.models.BotIntro;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.BotIntroState;
import io.intercom.android.sdk.ui.ReplySuggestion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer;", "", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "botIntro", "Lio/intercom/android/sdk/state/BotIntroState;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "(Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/models/ComposerSuggestions;Lio/intercom/android/sdk/state/BotIntroState;Lio/intercom/android/sdk/identity/UserIdentity;Lio/intercom/android/sdk/models/TeamPresence;)V", "computeUiState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "computeUiState$intercom_sdk_base_release", "intercom-sdk-base_release"})
public final class ConversationReducer {
    @NotNull
    private final AppConfig config;
    @NotNull
    private final ComposerSuggestions composerSuggestions;
    @NotNull
    private final BotIntroState botIntro;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final TeamPresence teamPresence;

    public ConversationReducer(@NotNull AppConfig config, @NotNull ComposerSuggestions composerSuggestions, @NotNull BotIntroState botIntro, @NotNull UserIdentity userIdentity, @NotNull TeamPresence teamPresence) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)composerSuggestions, (String)"composerSuggestions");
        Intrinsics.checkNotNullParameter((Object)botIntro, (String)"botIntro");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        this.config = config;
        this.composerSuggestions = composerSuggestions;
        this.botIntro = botIntro;
        this.userIdentity = userIdentity;
        this.teamPresence = teamPresence;
    }

    public /* synthetic */ ConversationReducer(AppConfig appConfig, ComposerSuggestions composerSuggestions, BotIntroState botIntroState, UserIdentity userIdentity, TeamPresence teamPresence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            AppConfig appConfig2 = Injector.get().getAppConfigProvider().get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig2, (String)"get().appConfigProvider.get()");
            appConfig = appConfig2;
        }
        if ((n & 2) != 0) {
            ComposerSuggestions composerSuggestions2 = Injector.get().getStore().state().composerSuggestions();
            Intrinsics.checkNotNullExpressionValue((Object)composerSuggestions2, (String)"get().store.state()\n        .composerSuggestions()");
            composerSuggestions = composerSuggestions2;
        }
        if ((n & 4) != 0) {
            BotIntroState botIntroState2 = Injector.get().getStore().state().botIntroState();
            Intrinsics.checkNotNullExpressionValue((Object)botIntroState2, (String)"get().store.state().botIntroState()");
            botIntroState = botIntroState2;
        }
        if ((n & 8) != 0) {
            UserIdentity userIdentity2 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity2, (String)"get().userIdentity");
            userIdentity = userIdentity2;
        }
        if ((n & 0x10) != 0) {
            TeamPresence teamPresence2 = Injector.get().getStore().state().teamPresence();
            Intrinsics.checkNotNullExpressionValue((Object)teamPresence2, (String)"get().store.state().teamPresence()");
            teamPresence = teamPresence2;
        }
        this(appConfig, composerSuggestions, botIntroState, userIdentity, teamPresence);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConversationUiState computeUiState$intercom_sdk_base_release(@NotNull ConversationClientState clientState) {
        ConversationUiState conversationUiState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Conversation conversation = clientState.getConversation();
        String conversationId = clientState.getConversationId();
        NetworkResponse<Conversation.Builder> lastNetworkCall = clientState.getLastNetworkCall();
        boolean isLoadingExistingConversation = conversation == null && conversationId != null;
        if (isLoadingExistingConversation && lastNetworkCall != null && !(lastNetworkCall instanceof NetworkResponse.Success)) {
            conversationUiState = ErrorReducerKt.reduceError(lastNetworkCall);
        } else if (isLoadingExistingConversation) {
            conversationUiState = ConversationUiState.Loading.INSTANCE;
        } else {
            Iterable botIntroParts;
            Collection collection;
            List list;
            ConversationHeader headerState2 = HeaderReducerKt.reduceHeader(clientState, this.config, this.teamPresence);
            ComposerUiState composerUiState = ComposerStateReducerKt.reduceComposerState(clientState, this.config);
            List $this$computeUiState_u24lambda_u2d5 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            String string2 = this.config.getTemporaryExpectationsMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.temporaryExpectationsMessage");
            if (!StringsKt.isBlank((CharSequence)string2)) {
                String string3 = this.config.getTemporaryExpectationsMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.temporaryExpectationsMessage");
                $this$computeUiState_u24lambda_u2d5.add(new ContentRow.TemporaryExpectationRow(string3));
            }
            if (conversationId == null && clientState.getPendingMessages().isEmpty()) {
                $this$computeUiState_u24lambda_u2d5.add(new ContentRow.TeamPresenceRow(TeamPresenceReducer.INSTANCE.getTeamPresenceState(null, this.teamPresence, this.config)));
            }
            if (conversation == null && !BotIntro.BOT_INTRO_NULL.equals(this.botIntro)) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Part part;
                int n;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = this.botIntro.getBotIntro().getBlocks();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    List list2 = (List)item$iv$iv2;
                    collection = destination$iv$iv;
                    n = 0;
                    Part $this$computeUiState_u24lambda_u2d5_u24lambda_u2d1_u24lambda_u2d0 = part = new Part.Builder().withBlocks((List<Block.Builder>)it).withParticipantIsAdmin(true).build();
                    boolean bl2 = false;
                    $this$computeUiState_u24lambda_u2d5_u24lambda_u2d1_u24lambda_u2d0.setParticipant(this.botIntro.getBotIntro().getBuiltParticipant());
                    collection.add(part);
                }
                botIntroParts = (List)destination$iv$iv;
                $this$map$iv = botIntroParts;
                collection = $this$computeUiState_u24lambda_u2d5;
                boolean $i$f$mapIndexed = false;
                $this$mapTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void part2;
                    void index;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    part = (Part)item$iv$iv;
                    int $this$computeUiState_u24lambda_u2d5_u24lambda_u2d1_u24lambda_u2d0 = n;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    boolean showAvatarIfAvailable = CollectionsKt.getLastIndex((List)botIntroParts) == index && !Intrinsics.areEqual((Object)part2.getMessageStyle(), (Object)"quick_reply");
                    Intrinsics.checkNotNullExpressionValue((Object)part2, (String)"part");
                    String string4 = this.config.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"config.name");
                    collection2.add(new ContentRow.MessageRow(new ContentRow.MessageRow.PartWrapper((Part)part2, false, null, true, showAvatarIfAvailable, string4, false, null, 128, null)));
                }
                collection.addAll((List)destination$iv$iv);
            }
            $this$computeUiState_u24lambda_u2d5.addAll((Collection)ConversationPartsReducerKt.reduceMessages(clientState, this.userIdentity, this.config));
            if (conversation == null && clientState.getPendingMessages().isEmpty()) {
                List<Suggestion> list3 = this.composerSuggestions.getSuggestions();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"composerSuggestions.suggestions");
                if (!((Collection)list3).isEmpty()) {
                    Collection<ReplySuggestion> collection3;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    String string5 = this.composerSuggestions.getPrompt();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"composerSuggestions.prompt");
                    List<Suggestion> list4 = this.composerSuggestions.getSuggestions();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"composerSuggestions.suggestions");
                    botIntroParts = list4;
                    String string6 = string5;
                    collection = $this$computeUiState_u24lambda_u2d5;
                    boolean $i$f$map = false;
                    void $i$f$mapIndexed = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object item$iv$iv2;
                        item$iv$iv2 = (Suggestion)item$iv$iv;
                        collection3 = destination$iv$iv;
                        boolean bl4 = false;
                        String string7 = it.getUuid();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it.uuid");
                        String string8 = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it.text");
                        collection3.add(new ReplySuggestion(string7, string8));
                    }
                    collection3 = (List)destination$iv$iv;
                    List list5 = collection3;
                    String string9 = string6;
                    collection.add(new ContentRow.ComposerSuggestionRow(string9, list5));
                }
            }
            Iterable $this$forEachIndexed$iv = clientState.getPendingMessages().values();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PendingMessage item$iv$iv = (PendingMessage)item$iv;
                int index = n;
                boolean bl5 = false;
                boolean showAvatarIfAvailable = !Intrinsics.areEqual((Object)it.getPart().getMessageStyle(), (Object)"quick_reply");
                Part part = it.getPart();
                boolean bl6 = index == clientState.getPendingMessages().size() - 1;
                Integer n2 = it.isFailed() || it.getFailedImageUploadData() != null ? R.string.intercom_failed_delivery : R.string.intercom_message_state_sending;
                String string10 = this.config.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"config.name");
                $this$computeUiState_u24lambda_u2d5.add(new ContentRow.MessageRow(new ContentRow.MessageRow.PartWrapper(part, bl6, n2, false, showAvatarIfAvailable, string10, it.isFailed(), it.getFailedImageUploadData())));
            }
            if (clientState.isAdminTyping()) {
                $this$computeUiState_u24lambda_u2d5.add(ContentRow.AdminIsTypingRow.INSTANCE);
            }
            List list6 = CollectionsKt.build((List)list);
            conversationUiState = new ConversationUiState.Content(headerState2, list6, composerUiState);
        }
        return conversationUiState;
    }

    public ConversationReducer() {
        this(null, null, null, null, null, 31, null);
    }
}

