/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.m5.conversation.states.ConversationUiState;
import io.intercom.android.sdk.models.BotIntro;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.state.BotIntroState;
import io.intercom.android.sdk.ui.ReplySuggestion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer;", "", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "botIntro", "Lio/intercom/android/sdk/state/BotIntroState;", "(Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/models/ComposerSuggestions;Lio/intercom/android/sdk/state/BotIntroState;)V", "computeUiState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "computeUiState$intercom_sdk_base_release", "intercom-sdk-base_release"})
public final class ConversationReducer {
    @NotNull
    private final AppConfig config;
    @NotNull
    private final ComposerSuggestions composerSuggestions;
    @NotNull
    private final BotIntroState botIntro;

    public ConversationReducer(@NotNull AppConfig config, @NotNull ComposerSuggestions composerSuggestions, @NotNull BotIntroState botIntro) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)composerSuggestions, (String)"composerSuggestions");
        Intrinsics.checkNotNullParameter((Object)botIntro, (String)"botIntro");
        this.config = config;
        this.composerSuggestions = composerSuggestions;
        this.botIntro = botIntro;
    }

    public /* synthetic */ ConversationReducer(AppConfig appConfig, ComposerSuggestions composerSuggestions, BotIntroState botIntroState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            AppConfig appConfig2 = Injector.get().getAppConfigProvider().get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig2, (String)"get().appConfigProvider.get()");
            appConfig = appConfig2;
        }
        if ((n & 2) != 0) {
            ComposerSuggestions composerSuggestions2 = Injector.get().getStore().state().composerSuggestions();
            Intrinsics.checkNotNullExpressionValue((Object)composerSuggestions2, (String)"get().store.state()\n        .composerSuggestions()");
            composerSuggestions = composerSuggestions2;
        }
        if ((n & 4) != 0) {
            BotIntroState botIntroState2 = Injector.get().getStore().state().botIntroState();
            Intrinsics.checkNotNullExpressionValue((Object)botIntroState2, (String)"get().store.state().botIntroState()");
            botIntroState = botIntroState2;
        }
        this(appConfig, composerSuggestions, botIntroState);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConversationUiState computeUiState$intercom_sdk_base_release(@NotNull ConversationClientState clientState) {
        ConversationUiState conversationUiState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Conversation conversation = clientState.getConversation();
        String conversationId = clientState.getConversationId();
        if (conversation == null && conversationId != null) {
            conversationUiState = ConversationUiState.Loading.INSTANCE;
        } else {
            Suggestion part;
            Iterable $this$onEach$iv;
            Part it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$map;
            void $this$computeUiState_u24lambda_u2d6;
            List list;
            ConversationHeader conversationHeader;
            if (conversation == null) {
                String string2 = this.config.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.name");
                conversationHeader = new ConversationHeader(string2);
            } else {
                String string3 = conversation.getLastParticipatingAdmin().getFirstName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"conversation.lastParticipatingAdmin.firstName");
                conversationHeader = new ConversationHeader(string3);
            }
            ConversationHeader headerState2 = conversationHeader;
            List list2 = list = CollectionsKt.createListBuilder();
            ConversationHeader conversationHeader2 = headerState2;
            boolean bl = false;
            String string4 = this.config.getTemporaryExpectationsMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"config.temporaryExpectationsMessage");
            if (!StringsKt.isBlank((CharSequence)string4)) {
                String string5 = this.config.getTemporaryExpectationsMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"config.temporaryExpectationsMessage");
                $this$computeUiState_u24lambda_u2d6.add(new ContentRow.TemporaryExpectationRow(string5));
            }
            $this$computeUiState_u24lambda_u2d6.add(new ContentRow.TeamPresenceRow(TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation)));
            if (conversation == null && !BotIntro.BOT_INTRO_NULL.equals(this.botIntro)) {
                Iterable iterable = this.botIntro.getBotIntro().getBlocks();
                $i$f$map = false;
                Iterator iterator = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Part part2;
                    List list3 = (List)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Part $this$computeUiState_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0 = part2 = new Part.Builder().withBlocks((List<Block.Builder>)((Object)it)).withParticipantIsAdmin(true).build();
                    boolean bl3 = false;
                    $this$computeUiState_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.setParticipant(this.botIntro.getBotIntro().getBuiltParticipant());
                    collection.add(part2);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$onEach = false;
                Iterable $this$onEach_u24lambda_u2d16$iv = $this$mapTo$iv$iv = $this$onEach$iv;
                boolean bl4 = false;
                for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
                    it = (Part)element$iv;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    $this$computeUiState_u24lambda_u2d6.add(new ContentRow.MessageRow(it));
                }
            }
            if (conversation != null) {
                List<Part> list4 = conversation.getParts();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"conversation.parts");
                $this$onEach$iv = list4;
                collection = $this$computeUiState_u24lambda_u2d6;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Part)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl6 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)part, (String)"part");
                    collection2.add(new ContentRow.MessageRow((Part)((Object)part)));
                }
                collection.addAll((List)destination$iv$iv);
            }
            if (conversation == null && clientState.getPendingMessages().isEmpty()) {
                List<Suggestion> list5 = this.composerSuggestions.getSuggestions();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"composerSuggestions.suggestions");
                if (!((Collection)list5).isEmpty()) {
                    Collection<ReplySuggestion> collection3;
                    String string6 = this.composerSuggestions.getPrompt();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"composerSuggestions.prompt");
                    List<Suggestion> list6 = this.composerSuggestions.getSuggestions();
                    Intrinsics.checkNotNullExpressionValue(list6, (String)"composerSuggestions.suggestions");
                    $this$map$iv = list6;
                    String string7 = string6;
                    collection = $this$computeUiState_u24lambda_u2d6;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        part = (Suggestion)item$iv$iv;
                        collection3 = destination$iv$iv;
                        boolean bl7 = false;
                        String string8 = ((Suggestion)((Object)it)).getUuid();
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it.uuid");
                        String string9 = ((Suggestion)((Object)it)).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"it.text");
                        collection3.add(new ReplySuggestion(string8, string9));
                    }
                    collection3 = (List)destination$iv$iv;
                    List list7 = collection3;
                    String string10 = string7;
                    collection.add(new ContentRow.ComposerSuggestionRow(string10, list7));
                }
            }
            Iterable $this$forEach$iv = clientState.getPendingMessages();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Part it2 = (Part)element$iv;
                boolean bl8 = false;
                $this$computeUiState_u24lambda_u2d6.add(new ContentRow.MessageRow(it2));
            }
            if (clientState.isAdminTyping()) {
                $this$computeUiState_u24lambda_u2d6.add(ContentRow.AdminIsTypingRow.INSTANCE);
            }
            List list8 = CollectionsKt.build((List)list);
            ConversationHeader conversationHeader3 = conversationHeader2;
            conversationUiState = new ConversationUiState.Content(conversationHeader3, list8);
        }
        return conversationUiState;
    }

    public ConversationReducer() {
        this(null, null, null, 7, null);
    }
}

