/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.SuccessResult;
import coil.transform.RoundedCornersTransformation;
import coil.transform.Transformation;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.intercom.commons.utilities.ScreenUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.ImageBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.AccessibilityUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.coil.GrayscaleTransformation;
import io.intercom.android.sdk.utilities.coil.RoundedCornersAnimatedTransformation;
import io.intercom.android.sdk.views.IntercomShimmerLayout;
import io.intercom.android.sdk.views.ResizableImageView;
import org.jetbrains.annotations.NotNull;

public class NetworkImage
extends Image
implements ImageBlock {
    private final UploadingImageCache uploadingImageCache;
    @Nullable
    private final ImageClickListener listener;
    private final Twig twig = LumberMill.getLogger();

    NetworkImage(StyleType style2, UploadingImageCache uploadingImageCache, @Nullable ImageClickListener listener) {
        super(style2);
        this.uploadingImageCache = uploadingImageCache;
        this.listener = listener;
    }

    @Override
    public View addImage(String url, String linkUrl, String description, int width, int height, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        int widthPx = ScreenUtils.dpToPx((float)width, (Context)context);
        int heightPx = ScreenUtils.dpToPx((float)height, (Context)context);
        IntercomShimmerLayout rootView = new IntercomShimmerLayout(context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        ResizableImageView imageView = new ResizableImageView(context);
        imageView.setTransitionName("lightbox_image");
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        this.setBackground((ImageView)imageView);
        rootView.addView((View)imageView);
        this.loadImageFromUrl(url, linkUrl, context, widthPx, heightPx, imageView, rootView);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), blockMetadata.isLastObject());
        if (TextUtils.isEmpty((CharSequence)linkUrl) && TextUtils.isEmpty((CharSequence)description)) {
            AccessibilityUtils.INSTANCE.removeClickAbilityAnnouncement((View)imageView);
        } else if (!TextUtils.isEmpty((CharSequence)description)) {
            imageView.setFocusable(true);
            imageView.setContentDescription(description);
        }
        return rootView;
    }

    private void loadImageFromUrl(final String url, final String linkUrl, final Context context, final int widthPx, final int heightPx, final ResizableImageView imageView, final ShimmerFrameLayout shimmerView) {
        Uri localImageUri;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.hideLoadingState(shimmerView, (ImageView)imageView);
            imageView.setImageResource(R.drawable.intercom_image_load_failed);
            imageView.setScaleType(ImageView.ScaleType.CENTER);
            return;
        }
        ImageRequest.Builder imageRequestBuilder = new ImageRequest.Builder(context).error(R.drawable.intercom_image_load_failed).crossfade(true).target((ImageView)imageView).data((Object)url);
        this.setImageViewBounds(widthPx, heightPx, imageView, imageRequestBuilder);
        Resources resources = context.getResources();
        if (this.getStyle() != StyleType.CAROUSEL) {
            if (ImageUtils.isGif(url)) {
                imageRequestBuilder.setParameter("coil#animated_transformation", (Object)new RoundedCornersAnimatedTransformation(resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners)));
            } else {
                imageRequestBuilder.transformations(new Transformation[]{new RoundedCornersTransformation((float)resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners))});
            }
        }
        if ((localImageUri = this.uploadingImageCache.getLocalImageUriForRemoteUrl(url)) != null) {
            imageRequestBuilder.transformations(new Transformation[]{new GrayscaleTransformation()}).data((Object)localImageUri);
        }
        imageRequestBuilder.listener(new ImageRequest.Listener(){

            public void onStart(@NotNull ImageRequest imageRequest) {
            }

            public void onCancel(@NotNull ImageRequest imageRequest) {
            }

            public void onError(@NonNull ImageRequest imageRequest, @NonNull ErrorResult errorResult) {
                imageView.setScaleType(ImageView.ScaleType.CENTER);
                NetworkImage.this.hideLoadingState(shimmerView, (ImageView)imageView);
                NetworkImage.this.twig.internal("images", "FAILURE");
                imageView.setScaleType(ImageView.ScaleType.CENTER);
            }

            public void onSuccess(@NonNull ImageRequest imageRequest, @NonNull SuccessResult successResult) {
                NetworkImage.this.twig.internal("images", "SUCCESS");
                NetworkImage.this.hideLoadingState(shimmerView, (ImageView)imageView);
                if (NetworkImage.this.getStyle() != StyleType.CHAT_FULL && NetworkImage.this.listener != null) {
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                            NetworkImage.this.listener.onImageClicked(url, linkUrl, (View)imageView, widthPx, heightPx);
                        }
                    });
                }
            }
        });
        IntercomCoilKt.loadIntercomImage(context, imageRequestBuilder.build());
    }

    @VisibleForTesting
    int getSampleSize(int scaledWidth, int scaledHeight, DisplayMetrics displayMetrics) {
        int sampleSize = 1;
        if (scaledWidth > displayMetrics.widthPixels || scaledHeight > displayMetrics.heightPixels) {
            sampleSize = (int)Math.pow(2.0, (int)Math.ceil(Math.log((double)displayMetrics.widthPixels / (double)Math.max(scaledHeight, scaledWidth)) / Math.log(0.5)));
        }
        return sampleSize;
    }

    void hideLoadingState(ShimmerFrameLayout shimmerView, ImageView imageView) {
        if (shimmerView != null) {
            shimmerView.hideShimmer();
            imageView.setBackgroundResource(17170445);
        }
    }
}

