/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.util.Base64;
import com.intercom.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.api.UserLocaleUtilKt;
import io.intercom.android.sdk.identity.AppIdentity;
import java.io.IOException;
import java.util.Random;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class HeaderInterceptor
implements Interceptor {
    private static final String WRAPPER_PREFS = "intercomsdk_wrapper_prefs";
    private static final String CORDOVA_VERSION = "cordova_version";
    private static final String REACT_NATIVE_VERSION = "react_native_version";
    private static final String INTERCOM_AGENT = "X-INTERCOM-AGENT";
    private static final String INTERCOM_AGENT_WRAPPER = "X-INTERCOM-AGENT-WRAPPER";
    private static final String ANDROID_HEADER = "intercom-android-sdk/";
    private static final String CORDOVA_HEADER = "intercom-sdk-cordova/";
    private static final String REACT_NATIVE_HEADER = "intercom-sdk-react-native/";
    private static final String IDEMPOTENCY_KEY = "Idempotency-Key";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final String ACCEPT_LANGUAGE = "Accept-Language";
    private static final String SUPPORTED_LANGUAGES_KEY = "X-INTERCOM-SUPPORTED-LANGUAGES";
    private static final String SUPPORTED_LANGUAGE_LIST = "ar,bg,bs,ca,cs,da,de,de-form,el,es,et,fi,fr,he,hr,hu,id,it,ja,ko,lt,lv,mn,nb,nl,pl,pt-PT,pt-BR,ro,ru,sl,sr,sv,tr,uk,vi,zh-Hant,zh-Hans";
    private static final String HOST_APP_VERSION_KEY = "X-INTERCOM-HOST-APP-VERSION";
    private final String cordovaVersion;
    private final String reactNativeVersion;
    private final String versionName;
    private final AppIdentity appIdentity;
    private final String userLocale;
    private final String appVersion;
    private final Random random;

    public static HeaderInterceptor create(Context context, AppIdentity appIdentity) {
        String cordovaVersion = context.getSharedPreferences(WRAPPER_PREFS, 0).getString(CORDOVA_VERSION, "");
        String reactNativeVersion = context.getSharedPreferences(WRAPPER_PREFS, 0).getString(REACT_NATIVE_VERSION, "");
        String userLocaleString = UserLocaleUtilKt.getUserLocaleString(context);
        String appVersion = DeviceUtils.getAppVersion((Context)context);
        return new HeaderInterceptor(cordovaVersion, reactNativeVersion, "12.5.1", appIdentity, userLocaleString, appVersion, new Random());
    }

    HeaderInterceptor(String cordovaVersion, String reactNativeVersion, String versionName, AppIdentity appIdentity, String userLocale, String appVersion, Random random) {
        this.cordovaVersion = cordovaVersion;
        this.reactNativeVersion = reactNativeVersion;
        this.versionName = versionName;
        this.appIdentity = appIdentity;
        this.userLocale = userLocale;
        this.appVersion = appVersion;
        this.random = random;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder().header(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE).header(AUTHORIZATION, this.getBasicAuth()).header(IDEMPOTENCY_KEY, Long.toHexString(this.random.nextLong())).header(INTERCOM_AGENT, ANDROID_HEADER + this.versionName).header(ACCEPT_LANGUAGE, this.userLocale).header(SUPPORTED_LANGUAGES_KEY, SUPPORTED_LANGUAGE_LIST).header(HOST_APP_VERSION_KEY, this.appVersion);
        if (!this.cordovaVersion.isEmpty()) {
            requestBuilder.header(INTERCOM_AGENT_WRAPPER, CORDOVA_HEADER + this.cordovaVersion);
        }
        if (!this.reactNativeVersion.isEmpty()) {
            requestBuilder.header(INTERCOM_AGENT_WRAPPER, REACT_NATIVE_HEADER + this.reactNativeVersion);
        }
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }

    private String getBasicAuth() {
        String authString = this.appIdentity.appId() + ":" + this.appIdentity.apiKey();
        return "Basic " + Base64.encodeToString((byte[])authString.getBytes(), (int)2);
    }

    public static void setCordovaVersion(Context context, String cordovaVersion) {
        context.getSharedPreferences(WRAPPER_PREFS, 0).edit().putString(CORDOVA_VERSION, cordovaVersion).apply();
    }

    public static void setReactNativeVersion(Context context, String reactNativeVersion) {
        context.getSharedPreferences(WRAPPER_PREFS, 0).edit().putString(REACT_NATIVE_VERSION, reactNativeVersion).apply();
    }
}

