/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.TextView;
import com.intercom.commons.utilities.ScreenUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.ChatFull;
import io.intercom.android.sdk.overlay.ChatSnippet;
import io.intercom.android.sdk.overlay.InAppNotification;
import io.intercom.android.sdk.overlay.StackableSnippet;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.SystemSettings;
import io.intercom.android.sdk.utilities.ViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class InAppNotificationPresenter
implements InAppNotification.Listener,
View.OnClickListener {
    private static final int PILL_START_OFFSET_DP = 66;
    private static final int MAX_DISPLAYED_NOTIFICATIONS = 3;
    private final Twig twig = LumberMill.getLogger();
    private final Listener listener;
    private final LayoutInflater inflater;
    private final Map<String, InAppNotification> notifications = new HashMap<String, InAppNotification>();
    private final List<Conversation> lastDisplayedConversations = new ArrayList<Conversation>();
    final Handler handler;
    private final MetricTracker metricTracker;
    private final Provider<AppConfig> appConfigProvider;
    private final ContextLocaliser contextLocaliser;
    private final Activity activity;
    private boolean hasAnimated = false;
    private float pillPosition;
    private int bottomPadding = 0;

    public InAppNotificationPresenter(LayoutInflater inflater, Handler handler, Listener listener, MetricTracker metricTracker, Provider<AppConfig> appConfigProvider2, ContextLocaliser contextLocaliser, Activity activity) {
        this.inflater = inflater;
        this.listener = listener;
        this.handler = handler;
        this.metricTracker = metricTracker;
        this.appConfigProvider = appConfigProvider2;
        this.contextLocaliser = contextLocaliser;
        this.activity = activity;
    }

    public void displayNotifications(final ViewGroup root, final List<Conversation> conversations) {
        ViewUtils.waitForViewAttachment((View)root, new Runnable(){

            @Override
            public void run() {
                InAppNotificationPresenter.this.displayNotificationsAfterAttach(conversations, root);
            }
        });
    }

    void displayNotificationsAfterAttach(List<Conversation> conversations, ViewGroup root) {
        boolean hasChanged = !this.lastDisplayedConversations.equals(conversations) && !this.notifications.isEmpty();
        HashMap<String, InAppNotification> notifications = new HashMap<String, InAppNotification>(this.notifications);
        if (hasChanged) {
            this.updateNotifications(conversations, notifications, root);
        } else if (!this.isDisplaying()) {
            this.addNewNotifications(conversations, root);
        }
        this.hasAnimated = true;
        Resources res = root.getResources();
        this.pillPosition = root.getHeight() - res.getDimensionPixelSize(R.dimen.intercom_overlay_pill_bottom_margin) - res.getDimensionPixelSize(R.dimen.intercom_bottom_padding) - this.bottomPadding;
        this.displayPill(this.inflater, root);
        this.lastDisplayedConversations.clear();
        this.lastDisplayedConversations.addAll(conversations);
    }

    public boolean isDisplaying() {
        return !this.notifications.isEmpty();
    }

    public void reset(ViewGroup root) {
        for (InAppNotification notification : this.notifications.values()) {
            notification.removeView();
        }
        View pill = root.findViewById(R.id.notification_pill);
        if (pill != null) {
            root.removeView(pill);
        }
        this.notifications.clear();
    }

    @Override
    public void onInAppNotificationTap(Conversation conversation) {
        this.listener.openNotification(conversation);
    }

    @Override
    public void onInAppNotificationDismiss(InAppNotification notification) {
        Part lastPart;
        ViewGroup rootView = null;
        try {
            rootView = this.listener.getRootView();
        }
        catch (Exception e) {
            this.twig.internal("Couldn't get root view: " + e.getMessage());
        }
        Conversation conversation = notification.getConversation();
        if (rootView != null) {
            this.listener.markAsDismissed(conversation);
            rootView.removeView(notification.getRootView());
            this.notifications.remove(conversation.getId());
            this.lastDisplayedConversations.remove(conversation);
            for (InAppNotification current : this.notifications.values()) {
                current.moveForward(rootView, this.inflater);
            }
            this.displayPill(this.inflater, rootView);
            if (this.notifications.isEmpty()) {
                this.hasAnimated = false;
            }
        }
        if ("chat".equals((lastPart = conversation.getLastAdminPart()).getMessageStyle()) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
            this.metricTracker.closedInAppFromFull(conversation.getId(), lastPart.getId());
        } else if (lastPart.isInitialMessage()) {
            this.metricTracker.dismissInAppMessageSnippet(conversation.getId(), lastPart.getId());
        } else {
            this.metricTracker.dismissInAppCommentSnippet(conversation.getId(), lastPart.getId());
        }
    }

    public void onClick(View view) {
        view.getContext().startActivity(IntercomMessengerActivity.openInbox(view.getContext()));
    }

    private void addNewNotifications(List<Conversation> conversations, ViewGroup root) {
        int count = conversations.size();
        for (int i = 0; i < count; ++i) {
            Conversation conversation = conversations.get(i);
            Context localisedContext = this.contextLocaliser.createLocalisedContext(root.getContext());
            Part lastPart = conversation.getLastPart();
            InAppNotification notification = count >= 2 || !"chat".equals(lastPart.getMessageStyle()) ? new StackableSnippet(localisedContext, conversation, i, this.handler, root.getHeight(), this, this.appConfigProvider) : (lastPart.getDeliveryOption() == Part.DeliveryOption.SUMMARY ? new ChatSnippet(localisedContext, conversation, i, root.getHeight(), this, this.appConfigProvider) : new ChatFull(localisedContext, conversation, i, root.getHeight(), this, this.metricTracker, this.appConfigProvider, this.activity));
            this.notifications.put(conversation.getId(), notification);
            if (i >= 3) continue;
            notification.display(root, this.inflater, !this.hasAnimated, this.bottomPadding);
        }
    }

    private void updateNotifications(final List<Conversation> conversations, final Map<String, InAppNotification> notifications, final ViewGroup root) {
        final Conversation conversation = conversations.get(0);
        Iterator<InAppNotification> iterator = notifications.values().iterator();
        InAppNotification firstNotification = iterator.next();
        while (iterator.hasNext()) {
            InAppNotification p = iterator.next();
            if (p.getPosition() >= firstNotification.getPosition()) continue;
            firstNotification = p;
        }
        if (this.isReply(conversation)) {
            firstNotification.update(conversation, new Runnable(){

                @Override
                public void run() {
                    InAppNotificationPresenter.this.syncUpdates(conversations, notifications, root);
                }
            });
        } else if (notifications.size() == 1 && firstNotification instanceof ChatSnippet) {
            firstNotification.moveBackward(root, new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InAppNotificationPresenter.this.addNewView(conversation, root, notifications);
                    InAppNotificationPresenter.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            InAppNotificationPresenter.this.syncUpdates(conversations, notifications, root);
                        }
                    }, 220L);
                }
            });
        } else {
            for (InAppNotification notification : notifications.values()) {
                if (notification.getPosition() < 3) {
                    notification.moveBackward(root);
                    continue;
                }
                notification.setPosition(notification.getPosition() + 1);
            }
            this.addNewView(conversation, root, notifications);
            this.syncUpdates(conversations, notifications, root);
        }
    }

    void addNewView(Conversation conversation, ViewGroup root, Map<String, InAppNotification> temp) {
        Context localisedContext = this.contextLocaliser.createLocalisedContext(root.getContext());
        StackableSnippet notification = new StackableSnippet(localisedContext, conversation, 0, this.handler, root.getHeight(), this, this.appConfigProvider);
        ((InAppNotification)notification).display(root, this.inflater, true, this.bottomPadding);
        if (temp.containsKey(conversation.getId())) {
            temp.get(conversation.getId()).removeView();
        }
        temp.put(conversation.getId(), notification);
    }

    void syncUpdates(List<Conversation> conversations, Map<String, InAppNotification> notifications, ViewGroup root) {
        for (int i = 0; i < conversations.size(); ++i) {
            Conversation conversation = conversations.get(i);
            InAppNotification notification = notifications.remove(conversation.getId());
            if (notification instanceof ChatSnippet && i > 0 || notification == null) {
                if (notification != null) {
                    notification.removeView();
                }
                Context localisedContext = this.contextLocaliser.createLocalisedContext(root.getContext());
                notification = new StackableSnippet(localisedContext, conversation, i, this.handler, root.getHeight(), this, this.appConfigProvider);
            }
            if (i < 3) {
                notification.display(root, conversation, this.inflater, false, this.bottomPadding);
            } else {
                notification.removeView();
            }
            this.notifications.put(conversation.getId(), notification);
        }
        for (InAppNotification notification : notifications.values()) {
            notification.removeView();
        }
    }

    private void displayPill(LayoutInflater inflater, ViewGroup root) {
        TextView pill = (TextView)root.findViewById(R.id.notification_pill);
        if (this.notifications.size() <= 3) {
            if (pill != null) {
                root.removeView((View)pill);
            }
        } else {
            if (pill == null) {
                inflater.inflate(R.layout.intercom_notification_pill, root, true);
                pill = (TextView)root.findViewById(R.id.notification_pill);
                pill.setAlpha(0.0f);
                pill.setScaleX(0.4f);
                pill.setScaleY(0.4f);
                pill.setY(this.pillPosition);
                pill.setOnClickListener((View.OnClickListener)this);
                this.animatePill((View)pill);
            }
            Context localised = this.contextLocaliser.createLocalisedContext(pill.getContext());
            Phrase.from(localised, R.string.intercom_plus_x_more).put("n", this.notifications.size() - 3).into(pill);
        }
    }

    private void animatePill(final View view) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                view.setY(InAppNotificationPresenter.this.pillPosition + (float)ScreenUtils.dpToPx((float)66.0f, (Context)view.getContext()));
                view.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator()).y(InAppNotificationPresenter.this.pillPosition).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).start();
            }
        }, (long)(500.0f * SystemSettings.getTransitionScale(view.getContext())));
    }

    private void updatePillPosition(View view) {
        PropertyValuesHolder y = PropertyValuesHolder.ofFloat((String)"y", (float[])new float[]{view.getY(), this.pillPosition});
        ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{y}).setDuration(300L).start();
    }

    private boolean isReply(Conversation conversation) {
        return !this.lastDisplayedConversations.isEmpty() && conversation.getId().equals(this.lastDisplayedConversations.get(0).getId());
    }

    public void setBottomPadding(int bottomPadding) {
        this.bottomPadding = bottomPadding;
        if (!this.isDisplaying()) {
            return;
        }
        for (InAppNotification notification : this.notifications.values()) {
            notification.updateBottomPadding(this.inflater.getContext(), this.bottomPadding);
        }
        ViewGroup rootView = null;
        try {
            rootView = this.listener.getRootView();
        }
        catch (Exception e) {
            this.twig.internal("Couldn't get root view: " + e.getMessage());
        }
        if (rootView != null) {
            Resources res = rootView.getResources();
            this.pillPosition = rootView.getHeight() - res.getDimensionPixelSize(R.dimen.intercom_overlay_pill_bottom_margin) - res.getDimensionPixelSize(R.dimen.intercom_bottom_padding) - bottomPadding;
            View pill = rootView.findViewById(R.id.notification_pill);
            if (pill != null) {
                this.updatePillPosition(pill);
            }
        }
    }

    static interface Listener {
        public ViewGroup getRootView() throws Exception;

        public void markAsDismissed(Conversation var1);

        public void openNotification(Conversation var1);
    }
}

