/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.snackbar.Snackbar;
import com.intercom.commons.utilities.TimeProvider;
import com.intercom.input.gallery.GalleryImage;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.ConversationReactionListener;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.BlockFactory;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.Blocks;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.BlockAttachment;
import io.intercom.android.sdk.blocks.logic.TextSplittingStrategy;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.ConversationPartAdapter;
import io.intercom.android.sdk.conversation.ProfileExpansionLogic;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.composer.ComposerPresenter;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.helpcenter.articles.ArticleStatsArguments;
import io.intercom.android.sdk.homescreen.ConversationListExtensionsKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.profile.ProfilePresenter;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.KeyboardUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.utilities.connectivity.NetworkConnectivityMonitor;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.IntercomToolbar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ConversationFragment
extends Fragment
implements ConversationPartAdapter.Listener,
IntercomToolbar.Listener,
Store.Subscriber2<Integer, TeamPresence>,
ConversationContentPresenter.Host,
View.OnClickListener {
    private static final String ARG_IS_READ = "intercomsdk-isRead";
    private static final String ARG_CONVERSATION_ID = "conversationId";
    private static final String ARG_ARTICLE_ARGS = "articleArgs";
    private static final String ARG_LAST_PARTICIPANT = "last_participant";
    private static final String ARG_GROUP_PARTICIPANTS = "group_participants";
    private static final String ARG_CLOSED_CONVERSATION_ID = "closed_conversation_id";
    private static final String ARG_INITIAL_MESSAGE = "initial_message";
    private static final String IMAGE_MIME_TYPE = "image";
    private static final int COMPOSER_LIGHTBOX_REQUEST_CODE = 25;
    private static final String EXTRA_GALLERY_IMAGE = "gallery_image";
    final NetworkConnectivityMonitor networkConnectivityMonitor = new NetworkConnectivityMonitor();
    private final ProfileExpansionLogic profileExpansionLogic = new ProfileExpansionLogic();
    @VisibleForTesting
    Listener listener;
    String conversationId;
    ArticleStatsArguments articleStatsArguments;
    View rootView;
    private ReactionInputView reactionComposer;
    private IntercomErrorView intercomErrorView;
    private IntercomToolbar intercomToolbar;
    private LinearLayout newConversationContainer;
    private TextView newConversationButton;
    Conversation conversation;
    private LastParticipatingAdmin lastParticipant;
    private List<Participant> groupParticipants;
    private CharSequence lastActiveTime;
    private boolean canOpenProfile = true;
    private Bus bus;
    private NexusClient nexusClient;
    @VisibleForTesting
    Store<State> store;
    Provider<AppConfig> appConfigProvider;
    private UserIdentity userIdentity;
    private TimeProvider timeProvider;
    private RelativeLayout composerHolder;
    private boolean hasLoadedConversation = false;
    boolean orientationChanged = false;
    private int currentOrientation;
    boolean shouldStayAtBottom = false;
    private String closedConversationId = "";
    private String initialMessage = "";
    private MetricTracker metricTracker;
    private OpsMetricTracker opsMetricTracker;
    private Store.Subscription subscription;
    private Store.Subscription composerSuggestionsSubscription;
    private IntercomLinkView intercomLinkView;
    @VisibleForTesting
    ComposerPresenter composerPresenter;
    ConversationContentPresenter contentPresenter;
    ProfilePresenter profilePresenter;
    private ConversationPartAdapter conversationPartAdapter;
    private final ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
        private int previousHeight;

        public void onGlobalLayout() {
            int newHeight = ConversationFragment.this.rootView.getHeight();
            if (this.previousHeight != 0 && !ConversationFragment.this.orientationChanged && this.previousHeight > newHeight) {
                ConversationFragment.this.profilePresenter.closeProfile();
                if (ConversationFragment.this.shouldStayAtBottom) {
                    ConversationFragment.this.contentPresenter.scrollToBottom();
                    ConversationFragment.this.shouldStayAtBottom = false;
                }
            }
            if (ConversationFragment.this.orientationChanged && this.previousHeight != newHeight) {
                ConversationFragment.this.orientationChanged = false;
            }
            this.previousHeight = newHeight;
            if (ConversationFragment.this.composerPresenter != null) {
                ConversationFragment.this.contentPresenter.onGlobalLayout();
            }
        }
    };
    private final NetworkConnectivityMonitor.ConnectivityEventListener connectivityEventListener = new NetworkConnectivityMonitor.ConnectivityEventListener(){

        @Override
        public void onDisconnect() {
            Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_no_network_connection, (int)-2).show();
        }

        @Override
        public void onReconnect() {
            Snackbar.make((View)ConversationFragment.this.rootView, (int)R.string.intercom_connected, (int)0).setActionTextColor(ConversationFragment.this.appConfigProvider.get().getPrimaryColor()).setAction(R.string.intercom_dismiss, new View.OnClickListener(){

                public void onClick(View v) {
                }
            }).show();
        }
    };
    private final ComposerPresenter.Listener composerListener = new ComposerPresenter.Listener(){
        private final BlockFactory blockFactory = new BlockFactory(new TextSplittingStrategy());

        @Override
        public void onSendButtonPressed(CharSequence text) {
            String trimmedText = text.toString().trim();
            if (!trimmedText.isEmpty()) {
                ConversationFragment.this.opsMetricTracker.trackEvent("start", "time-to-process-action-send-part-ms");
                ConversationFragment.this.contentPresenter.sendPart(this.blockFactory.getBlocksForText(trimmedText));
                if (TextUtils.isEmpty((CharSequence)ConversationFragment.this.conversationId)) {
                    ConversationFragment.this.rootView.findViewById(R.id.disabled_view).setVisibility(0);
                }
            }
        }

        @Override
        public void onUploadImageSelected(GalleryImage galleryImage) {
            if ((long)galleryImage.getFileSize() > ConversationFragment.this.appConfigProvider.get().getUploadSizeLimit()) {
                this.showUploadError();
                return;
            }
            ConversationFragment.this.contentPresenter.uploadImage(this.createBlocks(galleryImage), galleryImage);
        }

        private List<Block.Builder> createBlocks(GalleryImage uploadImage) {
            ArrayList<Block.Builder> blocks = new ArrayList<Block.Builder>();
            if (uploadImage.getMimeType().contains(ConversationFragment.IMAGE_MIME_TYPE)) {
                blocks.add(new Block.Builder().withUri(uploadImage.getUri()).withType(BlockType.LOCALIMAGE.name()).withWidth(uploadImage.getImageWidth()).withHeight(uploadImage.getImageHeight()));
            } else {
                BlockAttachment attachment = new BlockAttachment.Builder().withName(uploadImage.getFileName()).withUrl(uploadImage.getUri().toString()).withContentType(uploadImage.getMimeType()).build();
                blocks.add(new Block.Builder().withAttachments(Collections.singletonList(attachment)).withType(BlockType.LOCAL_ATTACHMENT.name()));
            }
            return blocks;
        }

        private void showUploadError() {
            long maxUploadSizeMb = ConversationFragment.this.appConfigProvider.get().getUploadSizeLimit() / 1024L / 1024L;
            CharSequence errorString = Phrase.from(ConversationFragment.this.getContext(), R.string.intercom_file_too_big).put("limit", String.valueOf(maxUploadSizeMb)).format();
            new AlertDialog.Builder((Context)ConversationFragment.this.getActivity()).setTitle(R.string.intercom_failed_to_send).setMessage(errorString).setPositiveButton(17039370, (dialog, which) -> {}).show();
        }

        @Override
        public void onRemoteImageSelected(GalleryImage galleryImage) {
            ConversationFragment.this.contentPresenter.sendPart(Collections.singletonList(new Block.Builder().withType(ConversationFragment.IMAGE_MIME_TYPE).withUrl(galleryImage.getUri().toString()).withAttribution(galleryImage.getAttribution()).withHeight(galleryImage.getImageHeight()).withWidth(galleryImage.getImageWidth())));
            ConversationFragment.this.composerPresenter.returnToDefaultInput();
        }
    };

    public static ConversationFragment newInstance(String conversationId, LastParticipatingAdmin participant, boolean isRead, String initialMessage, List<Participant> groupParticipants, String closedConversationId, ArticleStatsArguments articleArgs) {
        ConversationFragment frag = new ConversationFragment();
        Bundle args2 = new Bundle();
        args2.putString(ARG_CONVERSATION_ID, conversationId);
        args2.putString(ARG_INITIAL_MESSAGE, initialMessage);
        args2.putString(ARG_CLOSED_CONVERSATION_ID, closedConversationId);
        args2.putParcelable(ARG_LAST_PARTICIPANT, (Parcelable)participant);
        args2.putParcelableArrayList(ARG_GROUP_PARTICIPANTS, new ArrayList<Participant>(groupParticipants));
        args2.putBoolean(ARG_IS_READ, isRead);
        args2.putParcelable(ARG_ARTICLE_ARGS, (Parcelable)articleArgs);
        args2.setClassLoader(Part.class.getClassLoader());
        frag.setArguments(args2);
        return frag;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector2 = Injector.get();
        this.bus = injector2.getBus();
        this.nexusClient = injector2.getNexusClient();
        this.appConfigProvider = injector2.getAppConfigProvider();
        this.userIdentity = injector2.getUserIdentity();
        this.store = injector2.getStore();
        this.timeProvider = injector2.getTimeProvider();
        this.metricTracker = injector2.getMetricTracker();
        this.opsMetricTracker = injector2.getOpsMetricTracker();
        this.opsMetricTracker.trackEvent("start", "time-to-process-action-load-conversation-ms");
        Bundle args2 = this.getArguments();
        if (args2 != null) {
            boolean isRead;
            args2.setClassLoader(Part.class.getClassLoader());
            this.conversationId = args2.getString(ARG_CONVERSATION_ID, "");
            this.initialMessage = args2.getString(ARG_INITIAL_MESSAGE, "");
            this.articleStatsArguments = (ArticleStatsArguments)args2.getParcelable(ARG_ARTICLE_ARGS);
            if (this.articleStatsArguments == null) {
                this.articleStatsArguments = new ArticleStatsArguments();
            }
            this.lastParticipant = (LastParticipatingAdmin)args2.getParcelable(ARG_LAST_PARTICIPANT);
            if (this.lastParticipant == null) {
                this.lastParticipant = LastParticipatingAdmin.NULL;
            }
            this.groupParticipants = args2.getParcelableArrayList(ARG_GROUP_PARTICIPANTS);
            if (this.groupParticipants == null) {
                this.groupParticipants = new ArrayList<Participant>();
            }
            if (!(isRead = args2.getBoolean(ARG_IS_READ, false))) {
                this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
            }
            this.closedConversationId = args2.getString(ARG_CLOSED_CONVERSATION_ID, "");
            if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
                this.store.dispatch(Actions.composerOpened());
            } else {
                this.store.dispatch(Actions.conversationOpened(this.conversationId));
            }
        }
        this.conversation = new Conversation();
        this.currentOrientation = this.getResources().getConfiguration().orientation;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 25: {
                if (data == null || !data.hasExtra(EXTRA_GALLERY_IMAGE)) {
                    return;
                }
                GalleryImage image = (GalleryImage)data.getParcelableExtra(EXTRA_GALLERY_IMAGE);
                this.composerListener.onUploadImageSelected(image);
                break;
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_conversation, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.intercomLinkView = (IntercomLinkView)this.rootView.findViewById(R.id.intercom_link);
        this.composerHolder = (RelativeLayout)this.rootView.findViewById(R.id.composer_holder);
        CoordinatorLayout coordinator = (CoordinatorLayout)this.rootView.findViewById(R.id.conversation_coordinator_layout);
        this.profilePresenter = new ProfilePresenter(coordinator, this.metricTracker, this.appConfigProvider);
        this.profilePresenter.setConversationId(this.conversationId);
        this.intercomErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_conversation);
        this.intercomErrorView.setActionButtonTextColor(this.appConfigProvider.get().getPrimaryColor());
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationFragment.this.displayLoadingView();
                ConversationFragment.this.contentPresenter.fetchConversation(ConversationFragment.this.conversationId);
            }
        });
        this.profilePresenter.addListener(new AppBarLayout.OnOffsetChangedListener(){

            public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                ConversationFragment.this.contentPresenter.onProfileScrolled();
            }
        });
        this.reactionComposer = (ReactionInputView)this.rootView.findViewById(R.id.reaction_input_view);
        this.newConversationContainer = (LinearLayout)this.rootView.findViewById(R.id.new_conversation_container);
        this.newConversationButton = (TextView)this.rootView.findViewById(R.id.new_conversation_button);
        this.newConversationButton.setOnClickListener((View.OnClickListener)this);
        this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.updateToolbarColors(this.appConfigProvider.get());
        this.intercomToolbar.updateToolbarSize();
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setLeftNavigationItemVisibility(0);
        this.intercomToolbar.animateBackButton();
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutListener);
        return this.rootView;
    }

    void displayLoadingView() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.composerPresenter.hideComposer();
            this.contentPresenter.showLoadingView();
        }
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.contentPresenter = this.createContentPresenter(view);
        FrameLayout composerContainer = (FrameLayout)this.rootView.findViewById(R.id.composer_container);
        composerContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ConversationFragment.this.contentPresenter.isAtBottom()) {
                    ConversationFragment.this.shouldStayAtBottom = true;
                }
            }
        });
        this.composerPresenter = new ComposerPresenter(this.composerListener, composerContainer, this.getChildFragmentManager(), LayoutInflater.from((Context)view.getContext()), this.nexusClient, this.userIdentity, this.appConfigProvider, this.metricTracker, this.conversationId, this.initialMessage, this.store, (Context)this.getActivity(), this.appConfigProvider.get().getPrimaryColor(), this.closedConversationId);
        this.contentPresenter.setup();
        this.composerPresenter.requestFocus();
        this.configureInputView(this.conversation);
        if (this.conversationId.isEmpty()) {
            this.showSuggestionsIfAvailable();
            this.contentPresenter.addBotIntro();
            this.contentPresenter.addTemporaryExpectationsMessage();
        } else {
            this.composerPresenter.setConversationId(this.conversationId);
            this.displayLoadingView();
        }
        if (this.conversationId.isEmpty()) {
            this.canOpenProfile = false;
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.getActivity() == null) {
                        return;
                    }
                    ConversationFragment.this.profilePresenter.profileAutoOpened();
                    ConversationFragment.this.profilePresenter.startOffsetListener();
                    ConversationFragment.this.contentPresenter.smoothScrollToTop();
                }
            }, 50L);
        }
    }

    private void showSuggestionsIfAvailable() {
        this.displayLoadingView();
        this.showConversationWithSuggestions(this.store.select(Selectors.COMPOSER_SUGGESTIONS));
        this.composerSuggestionsSubscription = this.store.subscribeToChanges(Selectors.COMPOSER_SUGGESTIONS, this::showConversationWithSuggestions);
    }

    private void showConversationWithSuggestions(ComposerSuggestions composerSuggestions) {
        if (!ComposerSuggestions.UNKNOWN.equals(composerSuggestions) && this.conversationId.isEmpty() && !composerSuggestions.isLoading()) {
            this.contentPresenter.addComposerSuggestionsPart(composerSuggestions);
            this.animateComposerIn();
            this.displayConversation();
        }
    }

    private ConversationContentPresenter createContentPresenter(View view) {
        Injector injector2 = Injector.get();
        RecyclerView conversationList = (RecyclerView)view.findViewById(R.id.conversation_list);
        Blocks blocks = new Blocks((Context)this.getActivity(), LumberMill.getBlocksTwig());
        Api api = injector2.getApi();
        ArrayList<Part> conversationParts = new ArrayList<Part>();
        ContextLocaliser contextLocaliser = new ContextLocaliser(this.appConfigProvider);
        Locale locale = this.getActivity().getApplication().getResources().getConfiguration().locale;
        this.conversationPartAdapter = ConversationPartAdapter.create((Activity)this.getActivity(), conversationParts, this, api, this.conversationId, this.appConfigProvider, this.userIdentity, this.timeProvider, contextLocaliser, this.metricTracker, locale);
        SoundPlayer soundPlayer = new SoundPlayer((Context)this.getActivity(), this.appConfigProvider);
        return ConversationContentPresenter.create(this, conversationList, this.conversationPartAdapter, this.intercomLinkView, this.appConfigProvider, api, conversationParts, this.conversationId, soundPlayer, blocks, this.userIdentity, this.opsMetricTracker, (Activity)this.getActivity(), this.store, this.nexusClient, this.articleStatsArguments);
    }

    private void configureInputView(Conversation conversation) {
        Part lastPart = conversation.getLastPart();
        if (this.store.select(Selectors.COMPOSER_SUGGESTIONS).isComposerDisabled() && this.conversationId.isEmpty()) {
            this.composerPresenter.hideComposer();
            this.reactionComposer.setVisibility(8);
        } else if (conversation.shouldPreventEndUserReplies()) {
            this.showConversationEndedView();
        } else if (ReactionReply.isNull(lastPart.getReactionReply()) && conversation.getComposerState().isVisible()) {
            this.composerPresenter.showComposer();
            this.composerPresenter.requestFocus();
            this.reactionComposer.setVisibility(8);
        } else {
            ConversationReactionListener listener = new ConversationReactionListener(MetricTracker.ReactionLocation.CONVERSATION, lastPart.getId(), conversation.getId(), Injector.get().getApi(), this.metricTracker);
            this.reactionComposer.setUpReactions(lastPart.getReactionReply(), true, listener);
            this.composerPresenter.hideComposer();
        }
    }

    private void showConversationEndedView() {
        KeyboardUtils.hideKeyboard((View)this.composerHolder);
        this.composerPresenter.hideComposer();
        this.newConversationContainer.setVisibility(0);
        if (this.shouldHideNewConversationButton()) {
            this.newConversationButton.setVisibility(8);
        } else {
            FontUtils.setRobotoMediumTypeface(this.newConversationButton);
            ViewCompat.setBackgroundTintList((View)this.newConversationButton, (ColorStateList)ColorStateList.valueOf((int)this.appConfigProvider.get().getPrimaryColor()));
            boolean shouldRenderDarkText = this.appConfigProvider.get().primaryColorRenderDarkText();
            int buttonTextColor = ColorUtils.whiteOrDarkColor(this.getContext(), shouldRenderDarkText);
            this.newConversationButton.setTextColor(buttonTextColor);
            ColorUtils.updateLeftDrawableColorAccordingToBrightness(this.newConversationButton, buttonTextColor);
        }
    }

    private boolean shouldHideNewConversationButton() {
        List<Conversation> conversations = this.store.state().inboxState().conversations();
        long currentTime = this.timeProvider.currentTimeMillis();
        boolean hasRecentInboundConversation = ConversationListExtensionsKt.hasRecentInboundConversation(conversations, currentTime);
        boolean hasOpenInboundAndMustPreventMultipleInbound = this.appConfigProvider.get().isPreventMultipleInboundConversationsEnabled() && hasRecentInboundConversation;
        return !this.appConfigProvider.get().isInboundMessages() || this.conversation.getInboundConversationsDisabled() || hasOpenInboundAndMustPreventMultipleInbound;
    }

    private void animateComposerIn() {
        Animation slideUp = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.intercom_composer_slide_up);
        this.composerHolder.setVisibility(0);
        this.intercomLinkView.startAnimation(slideUp);
        this.composerHolder.startAnimation(slideUp);
    }

    @VisibleForTesting
    void displayConversation() {
        if (this.isAdded()) {
            this.intercomErrorView.setVisibility(8);
            this.contentPresenter.showContentView();
            this.configureInputView(this.conversation);
        }
    }

    public void onStart() {
        super.onStart();
        this.networkConnectivityMonitor.startListening((Context)this.getActivity());
        this.networkConnectivityMonitor.setListener(this.connectivityEventListener);
        this.subscription = this.store.subscribeToChanges(Selectors.UNREAD_COUNT, Selectors.TEAM_PRESENCE, this);
        this.bus.register((Object)this);
        this.bus.register((Object)this.contentPresenter);
        this.contentPresenter.fetchConversation(this.conversationId);
    }

    boolean hasNotLoadedLastAdminForExistingConversation() {
        return !this.hasLoadedConversation && !this.conversationId.isEmpty() && LastParticipatingAdmin.isNull(this.lastParticipant);
    }

    private void updateProfileToolbar(TeamPresence teamPresence) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (LastParticipatingAdmin.isNull(this.lastParticipant) || this.lastParticipant == LastParticipatingAdmin.NONE) {
            int maxWidth = activity.getWindow().getDecorView().getMeasuredWidth();
            this.profilePresenter.setTeamPresence(teamPresence, maxWidth);
        } else {
            this.updateLastActiveTime();
            this.profilePresenter.setTeammatePresence(this.lastParticipant, this.groupParticipants, this.lastActiveTime, this.rootView.getWidth());
        }
    }

    private void updateLastActiveTime() {
        LastParticipatingAdmin lastAdmin = this.conversation.getLastParticipatingAdmin();
        if (lastAdmin != null && this.getActivity() != null) {
            TimeFormatter timeFormatter2 = new TimeFormatter((Context)this.getActivity(), this.timeProvider);
            this.lastActiveTime = timeFormatter2.getAdminActiveStatus(this.lastParticipant, this.appConfigProvider);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation != this.currentOrientation) {
            this.orientationChanged = true;
            this.composerPresenter.updateMaxLines();
        }
        this.currentOrientation = newConfig.orientation;
    }

    @Override
    public void onStateChange(Integer unreadCount, TeamPresence teamPresence) {
        this.intercomToolbar.setUnreadCount(unreadCount);
        if (this.hasNotLoadedLastAdminForExistingConversation()) {
            this.profilePresenter.setUnknownPresence();
        } else {
            this.updateProfileToolbar(teamPresence);
        }
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        this.bus.unregister((Object)this);
        this.bus.unregister((Object)this.contentPresenter);
        this.networkConnectivityMonitor.setListener(null);
        this.networkConnectivityMonitor.stopListening((Context)this.getActivity());
        this.opsMetricTracker.clear();
        this.profilePresenter.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        StoreUtils.safeUnsubscribe(this.composerSuggestionsSubscription);
        ViewUtils.removeGlobalLayoutListener(this.rootView, this.globalLayoutListener);
        this.composerPresenter.cleanup();
        this.contentPresenter.cleanup();
        this.profilePresenter.cleanup();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.store.dispatch(Actions.conversationClosed());
        super.onDestroy();
    }

    public void sdkWindowFinishedAnimating() {
        if (this.getView() != null && this.profileExpansionLogic.shouldExpandProfile(this.conversation)) {
            this.profilePresenter.profileAutoOpened();
            this.contentPresenter.smoothScrollToTop();
        }
    }

    @Override
    public String getConversationId() {
        return this.conversationId;
    }

    @Override
    public Conversation getConversation() {
        return this.conversation;
    }

    @Override
    public void onConversationCreated(Conversation conversation) {
        this.rootView.findViewById(R.id.disabled_view).setVisibility(8);
        this.conversation = conversation;
        this.conversationId = conversation.getId();
        this.profilePresenter.setConversationId(this.conversationId);
        this.composerPresenter.setConversationId(this.conversationId);
        this.composerPresenter.setHint(R.string.intercom_reply_to_conversation);
        this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
        Part part = conversation.getParts().get(0);
        if (TextUtils.isEmpty((CharSequence)this.closedConversationId)) {
            this.metricTracker.sentInNewConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId, this.store.select(Selectors.TEAM_PRESENCE).getOfficeHours().isEmpty());
            this.metricTracker.startConversation(this.conversationId);
        } else {
            this.metricTracker.sentInNewFollowupConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId, this.store.select(Selectors.TEAM_PRESENCE).getOfficeHours().isEmpty(), this.closedConversationId);
            this.metricTracker.startFollowupConversation(this.conversationId, this.closedConversationId);
        }
        this.hasLoadedConversation = true;
        this.configureInputView(conversation);
    }

    @Override
    public void onFormSubmitted() {
        this.composerPresenter.clearFocus();
        this.composerPresenter.requestFocus();
    }

    private void toggleProfile() {
        if (this.profilePresenter.isExpanded()) {
            this.profilePresenter.closeProfile();
        } else {
            this.profilePresenter.profileClicked();
            this.contentPresenter.smoothScrollToTop();
        }
    }

    @Subscribe
    public void conversationSuccess(ConversationEvent event) {
        boolean hasNewParts;
        int conversationSize = this.conversation.getParts().size();
        boolean initialLoad = conversationSize == 0;
        List<Part> eventParts = event.getResponse().getParts();
        boolean bl = hasNewParts = eventParts.size() > conversationSize;
        if (event.getResponse().getId().equals(this.conversationId)) {
            boolean isUnread;
            this.conversation = event.getResponse();
            if (this.isAdded()) {
                this.contentPresenter.onConversationFetched(event, initialLoad);
                this.displayConversation();
            }
            boolean bl2 = isUnread = !this.conversation.isRead();
            if (isUnread) {
                this.markConversationAsRead();
            }
            if (initialLoad) {
                this.animateComposerIn();
                Part lastPart = eventParts.get(eventParts.size() - 1);
                if (lastPart.isReply() && isUnread) {
                    this.trackLastPart(lastPart);
                }
                this.expandProfileIfNeeded();
            } else if (hasNewParts) {
                List<Part> newParts = eventParts.subList(conversationSize, eventParts.size());
                this.contentPresenter.playSoundForNewAdminPart(newParts);
                this.contentPresenter.onNewPartReceived();
                this.trackLastPart(newParts.get(newParts.size() - 1));
            }
        }
        this.lastParticipant = this.conversation.getLastParticipatingAdmin();
        this.groupParticipants = this.conversation.getGroupConversationParticipants();
        if (this.lastParticipant != null) {
            this.updateLastActiveTime();
        }
        this.updateProfileToolbar(this.store.select(Selectors.TEAM_PRESENCE));
        this.hasLoadedConversation = true;
    }

    private void markConversationAsRead() {
        Injector.get().getApi().markConversationAsRead(this.conversationId);
        this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
        this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
    }

    private void expandProfileIfNeeded() {
        View view;
        if (this.canOpenProfile && (view = this.getView()) != null) {
            final boolean profileWillOpen = this.profileExpansionLogic.shouldExpandProfile(this.conversation);
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ConversationFragment.this.getContext() == null) {
                        return;
                    }
                    if (profileWillOpen) {
                        ConversationFragment.this.profilePresenter.profileAutoOpened();
                        ConversationFragment.this.profilePresenter.startOffsetListener();
                        ConversationFragment.this.contentPresenter.smoothScrollToTop();
                    } else {
                        ConversationFragment.this.profilePresenter.startOffsetListener();
                    }
                }
            }, 50L);
            if (profileWillOpen) {
                this.contentPresenter.scrollToTop();
            } else {
                this.contentPresenter.scrollToBottom();
            }
            this.canOpenProfile = false;
        }
    }

    private void trackLastPart(Part part) {
        if (part.isLinkList()) {
            this.metricTracker.receivedOperatorReply(this.conversationId);
        } else {
            this.metricTracker.receivedReply(part.hasAttachments(), part.isLinkCard(), part.getId(), this.conversationId);
        }
    }

    @Subscribe
    public void conversationFailure(ConversationFailedEvent event) {
        if (this.isAdded()) {
            this.displayErrorView();
        }
    }

    private void displayErrorView() {
        this.intercomErrorView.setVisibility(0);
        this.composerHolder.setVisibility(8);
        this.contentPresenter.showErrorView();
    }

    @Subscribe
    public void replySuccess(ReplyEvent event) {
        if (event.getConversationId().equals(this.conversationId)) {
            this.nexusClient.fire(NexusEvent.getNewCommentEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
            Part part = event.getResponse();
            Participant participant = this.conversation.getParticipant(part.getParticipantId());
            if (participant == Participant.NULL) {
                participant = new Participant.Builder().withId(part.getParticipantId()).build();
                this.conversation.getParticipants().put(part.getParticipantId(), participant);
            }
            part.setParticipant(participant);
            this.contentPresenter.onReplyDelivered(event);
            TimeFormatter timeFormatter2 = new TimeFormatter((Context)this.getActivity(), this.timeProvider);
            this.metricTracker.sentInConversation(part.hasAttachments(), part.isGifOnlyPart(), part.getId(), this.conversationId, this.store.select(Selectors.TEAM_PRESENCE).getOfficeHours().isEmpty(), this.lastParticipant.isActive(), timeFormatter2.getLastActiveMinutes(this.lastParticipant.getLastActiveAt()));
        }
    }

    @Subscribe
    public void adminIsTyping(AdminIsTypingEvent event) {
        if (this.conversationId.equals(event.getConversationId())) {
            this.contentPresenter.onAdminStartedTyping(event);
        }
    }

    @Override
    public void onPartClicked(Part part) {
        this.contentPresenter.onPartClicked(part);
    }

    @Override
    public void onPostCardClicked(Part part) {
        this.startActivity(IntercomPostActivity.buildPostIntent(this.getContext(), part, "", this.lastParticipant, this.conversation.getComposerState().isVisible(), false));
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
        this.toggleProfile();
    }

    @Override
    public void onInboxClicked() {
        this.composerPresenter.cleanup();
        this.listener.onBackClicked();
    }

    public boolean shouldHandleOnBackPressed() {
        return this.composerPresenter != null && this.composerPresenter.isOpen();
    }

    public void handleOnBackPressed() {
        this.composerPresenter.onBackPressed();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.new_conversation_button) {
            this.listener.onStartAnotherConversation(this.conversationId);
        }
    }

    public static interface Listener {
        public void onToolbarCloseClicked();

        public void onBackClicked();

        public void onStartAnotherConversation(String var1);
    }
}

