/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.ImageView;
import androidx.compose.material.MaterialThemeKt;
import androidx.compose.material.Typography;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.ui.platform.ComposeView;
import androidx.compose.ui.platform.ViewCompositionStrategy;
import androidx.compose.ui.text.font.FontFamily;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.imageview.ShapeableImageView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.databinding.IntercomArticleSearchCardBinding;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.homescreen.ArticleSuggestionsComponentKt;
import io.intercom.android.sdk.homescreen.CardState;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.ArticleSuggestionModel;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lio/intercom/android/sdk/homescreen/ArticleSearchCardViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lio/intercom/android/sdk/databinding/IntercomArticleSearchCardBinding;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "homeClickListener", "Lio/intercom/android/sdk/homescreen/HomeClickListener;", "(Lio/intercom/android/sdk/databinding/IntercomArticleSearchCardBinding;Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/homescreen/HomeClickListener;)V", "getAppConfig", "()Lio/intercom/android/sdk/identity/AppConfig;", "getBinding", "()Lio/intercom/android/sdk/databinding/IntercomArticleSearchCardBinding;", "getHomeClickListener", "()Lio/intercom/android/sdk/homescreen/HomeClickListener;", "bindCard", "", "card", "Lio/intercom/android/sdk/homescreen/CardState$ArticleSearchCard;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "intercom-sdk-base_release"})
public final class ArticleSearchCardViewHolder
extends RecyclerView.ViewHolder {
    @NotNull
    private final IntercomArticleSearchCardBinding binding;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final HomeClickListener homeClickListener;

    public ArticleSearchCardViewHolder(@NotNull IntercomArticleSearchCardBinding binding, @NotNull AppConfig appConfig, @NotNull HomeClickListener homeClickListener) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)homeClickListener, (String)"homeClickListener");
        super((View)binding.getRoot());
        this.binding = binding;
        this.appConfig = appConfig;
        this.homeClickListener = homeClickListener;
        IntercomArticleSearchCardBinding $this$_init__u24lambda_u2d1 = this.binding;
        boolean bl = false;
        ColorUtils.updateInnerBorderColor(this.getAppConfig(), (View)$this$_init__u24lambda_u2d1.getRoot());
        int searchButtonBorder = ColorUtils.isColorLight(this.getAppConfig().getPrimaryColor()) ? ContextCompat.getColor((Context)$this$_init__u24lambda_u2d1.getRoot().getContext(), (int)R.color.intercom_black_20) : this.getAppConfig().getPrimaryColor();
        BackgroundUtils.setRippleButtonStroke($this$_init__u24lambda_u2d1.getRoot().getContext(), $this$_init__u24lambda_u2d1.articleSearchButton.getBackground(), R.id.background, searchButtonBorder);
        int backgroundColor = ContextCompat.getColor((Context)$this$_init__u24lambda_u2d1.getRoot().getContext(), (int)R.color.intercom_white);
        BackgroundUtils.setRippleButtonBackgroundColor($this$_init__u24lambda_u2d1.articleSearchButton.getBackground(), R.id.background, backgroundColor);
        ColorUtils.updateLeftDrawableColorAccordingToBrightness($this$_init__u24lambda_u2d1.articleSearchButton, this.getAppConfig().getPrimaryColor());
        $this$_init__u24lambda_u2d1.articleSearchButton.setOnClickListener(arg_0 -> ArticleSearchCardViewHolder.lambda-1$lambda-0(this, arg_0));
    }

    @NotNull
    public final IntercomArticleSearchCardBinding getBinding() {
        return this.binding;
    }

    @NotNull
    public final AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public final HomeClickListener getHomeClickListener() {
        return this.homeClickListener;
    }

    /*
     * WARNING - void declaration
     */
    public final void bindCard(@NotNull CardState.ArticleSearchCard card, @NotNull TeamPresence teamPresence) {
        boolean shouldShowTeammateHelp;
        ComposeView composeView;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        ComposeView $this$bindCard_u24lambda_u2d2 = composeView = this.binding.articleCardSuggestions;
        boolean bl3 = false;
        $this$bindCard_u24lambda_u2d2.setViewCompositionStrategy((ViewCompositionStrategy)ViewCompositionStrategy.DisposeOnViewTreeLifecycleDestroyed.INSTANCE);
        $this$bindCard_u24lambda_u2d2.setContent((Function2)ComposableLambdaKt.composableLambdaInstance((int)-985531593, (boolean)true, (Object)new Function2<Composer, Integer, Unit>($this$bindCard_u24lambda_u2d2, card){
            final /* synthetic */ ComposeView $this_apply;
            final /* synthetic */ CardState.ArticleSearchCard $card;
            {
                this.$this_apply = $receiver;
                this.$card = $card;
                super(2);
            }

            @Composable
            public final void invoke(@Nullable Composer $composer, int $changed) {
                if (($changed & 0xB ^ 2) != 0 || !$composer.getSkipping()) {
                    MaterialThemeKt.MaterialTheme(null, (Typography)new Typography((FontFamily)FontFamily.Companion.getSansSerif(), null, null, null, null, null, null, null, null, null, null, null, null, null, 16382, null), null, (Function2)((Function2)ComposableLambdaKt.composableLambda((Composer)$composer, (int)-819893130, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(this.$this_apply, this.$card){
                        final /* synthetic */ ComposeView $this_apply;
                        final /* synthetic */ CardState.ArticleSearchCard $card;
                        {
                            this.$this_apply = $receiver;
                            this.$card = $card;
                            super(2);
                        }

                        @Composable
                        public final void invoke(@Nullable Composer $composer, int $changed) {
                            if (($changed & 0xB ^ 2) != 0 || !$composer.getSkipping()) {
                                EffectsKt.LaunchedEffect((Object)this.$this_apply, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$card, null){
                                    int label;
                                    final /* synthetic */ CardState.ArticleSearchCard $card;
                                    {
                                        this.$card = $card;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void $this$mapTo$iv$iv;
                                                void $this$map$iv;
                                                ResultKt.throwOnFailure((Object)object);
                                                Iterable iterable = this.$card.getSuggestions();
                                                MetricTracker metricTracker = Injector.get().getMetricTracker();
                                                boolean $i$f$map = false;
                                                void var4_5 = $this$map$iv;
                                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                boolean $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    void it;
                                                    ArticleSuggestionModel articleSuggestionModel = (ArticleSuggestionModel)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl = false;
                                                    collection.add(it.getId());
                                                }
                                                metricTracker.viewedArticleSuggestions((List)destination$iv$iv);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Composer)$composer, (int)ComposeView.$stable);
                                ArticleSuggestionsComponentKt.ArticleSuggestionsComponent(this.$card.getSuggestions(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$this_apply){
                                    final /* synthetic */ ComposeView $this_apply;
                                    {
                                        this.$this_apply = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull String it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        Injector.get().getMetricTracker().clickedArticleSuggestion(it);
                                        Context context = this.$this_apply.getContext();
                                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                                        Intent intent = ArticleActivity.Companion.buildIntent(context, new ArticleActivity.ArticleActivityArguments(it, "home-screen", true));
                                        this.$this_apply.getContext().startActivity(intent);
                                    }
                                }), $composer, 8);
                            } else {
                                $composer.skipToGroupEnd();
                            }
                        }
                    })), (Composer)$composer, (int)3072, (int)5);
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }));
        boolean bl2 = shouldShowTeammateHelp = this.appConfig.isInboundMessages() && this.appConfig.isAccessToTeammateEnabled() && this.appConfig.isHelpCenterRequireSearchEnabled();
        if (shouldShowTeammateHelp) {
            void $this$forEachIndexed$iv;
            this.binding.articleCardAvatarsLayout.setVisibility(0);
            this.binding.articleSearchTitle.setText(R.string.intercom_get_help);
            List<Participant> bl3 = teamPresence.getActiveAdmins();
            Intrinsics.checkNotNullExpressionValue(bl3, (String)"teamPresence.activeAdmins");
            List<ArticleViewState.AvatarState> avatarStates = ArticleViewState.Companion.computeAvatarState(bl3);
            Object object = new ShapeableImageView[]{this.binding.articleCardAvatars.helpCenterArticleAvatar1, this.binding.articleCardAvatars.helpCenterArticleAvatar2, this.binding.articleCardAvatars.helpCenterArticleAvatar3};
            List avatarViews = CollectionsKt.listOf((Object[])object);
            object = CollectionsKt.takeLast(avatarStates, (int)3);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void avatarState;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ArticleViewState.AvatarState avatarState2 = (ArticleViewState.AvatarState)item$iv;
                int index = n;
                boolean bl4 = false;
                ((ShapeableImageView)avatarViews.get(index)).setVisibility(avatarState.getVisibility());
                AvatarUtils.loadAvatarIntoView(avatarState.getAvatar(), (ImageView)avatarViews.get(index), this.getAppConfig());
            }
        } else {
            this.binding.articleCardAvatarsLayout.setVisibility(8);
            this.binding.articleSearchTitle.setText(R.string.intercom_search_for_help);
        }
    }

    private static final void lambda-1$lambda-0(ArticleSearchCardViewHolder this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.homeClickListener.onArticleSearchClicked();
    }
}

