/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.homescreen.CardState;
import io.intercom.android.sdk.homescreen.ConversationListExtensionsKt;
import io.intercom.android.sdk.homescreen.HomeViewModel;
import io.intercom.android.sdk.homescreen.HomeViewState;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.HomeCard;
import io.intercom.android.sdk.models.HomeCardSlotType;
import io.intercom.android.sdk.models.HomeCardsResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001aJ\u0006\u0010\"\u001a\u00020\u001fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lio/intercom/android/sdk/homescreen/HomeViewModel;", "Landroidx/lifecycle/ViewModel;", "messengerApi", "Lio/intercom/android/sdk/api/MessengerApi;", "timeProvider", "Lcom/intercom/commons/utilities/TimeProvider;", "store", "Lio/intercom/android/sdk/store/Store;", "Lio/intercom/android/sdk/state/State;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/intercom/android/sdk/api/MessengerApi;Lcom/intercom/commons/utilities/TimeProvider;Lio/intercom/android/sdk/store/Store;Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/models/TeamPresence;Lio/intercom/android/sdk/metrics/MetricTracker;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_viewState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/homescreen/HomeViewState;", "viewState", "Lkotlinx/coroutines/flow/Flow;", "getViewState", "()Lkotlinx/coroutines/flow/Flow;", "computeUiState", "", "Lio/intercom/android/sdk/homescreen/CardState;", "homeCardResponse", "Lio/intercom/android/sdk/models/HomeCardsResponse;", "onRealTimeEvent", "", "conversations", "Lio/intercom/android/sdk/models/Conversation;", "onUiCreated", "Companion", "intercom-sdk-base_release"})
public final class HomeViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessengerApi messengerApi;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final Store<State> store;
    @NotNull
    private final AppConfig config;
    @NotNull
    private final TeamPresence teamPresence;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final MutableStateFlow<HomeViewState> _viewState;
    @NotNull
    private final Flow<HomeViewState> viewState;

    public HomeViewModel(@NotNull MessengerApi messengerApi, @NotNull TimeProvider timeProvider, @NotNull Store<State> store, @NotNull AppConfig config, @NotNull TeamPresence teamPresence, @NotNull MetricTracker metricTracker, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)messengerApi, (String)"messengerApi");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.messengerApi = messengerApi;
        this.timeProvider = timeProvider;
        this.store = store;
        this.config = config;
        this.teamPresence = teamPresence;
        this.metricTracker = metricTracker;
        this.dispatcher = dispatcher;
        this._viewState = StateFlowKt.MutableStateFlow((Object)HomeViewState.Initial.INSTANCE);
        this.viewState = (Flow)this._viewState;
    }

    public /* synthetic */ HomeViewModel(MessengerApi messengerApi, TimeProvider timeProvider, Store store, AppConfig appConfig, TeamPresence teamPresence, MetricTracker metricTracker, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(messengerApi, timeProvider, store, appConfig, teamPresence, metricTracker, coroutineDispatcher);
    }

    @NotNull
    public final Flow<HomeViewState> getViewState() {
        return this.viewState;
    }

    public final void onUiCreated() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HomeViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        HomeViewModel.access$get_viewState$p(this.this$0).setValue((Object)HomeViewState.Loading.INSTANCE);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = MessengerApi.DefaultImpls.getHomeCardsSuspend$default(HomeViewModel.access$getMessengerApi$p(this.this$0), null, (Continuation)this, 1, null);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        homeCardsResponse = (NetworkResponse)v0;
                        v1 = HomeViewModel.access$get_viewState$p(this.this$0);
                        var4_5 = homeCardsResponse;
                        if (var4_5 instanceof NetworkResponse.ApiError) {
                            v2 = HomeViewState.Error.INSTANCE;
                        } else if (var4_5 instanceof NetworkResponse.NetworkError) {
                            v2 = HomeViewState.Error.INSTANCE;
                        } else if (var4_5 instanceof NetworkResponse.Success) {
                            builtHomeCardsResponse = ((HomeCardsResponse.Builder)((NetworkResponse.Success)homeCardsResponse).getBody()).build();
                            BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, builtHomeCardsResponse, null){
                                int label;
                                final /* synthetic */ HomeViewModel this$0;
                                final /* synthetic */ HomeCardsResponse $builtHomeCardsResponse;
                                {
                                    this.this$0 = $receiver;
                                    this.$builtHomeCardsResponse = $builtHomeCardsResponse;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            HomeViewModel.access$getStore$p(this.this$0).dispatch(Actions.baseResponseReceived(this.$builtHomeCardsResponse));
                                            HomeViewModel.access$getStore$p(this.this$0).dispatch(Actions.fetchHomeCardsSuccess(this.$builtHomeCardsResponse));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            Intrinsics.checkNotNullExpressionValue((Object)builtHomeCardsResponse, (String)"builtHomeCardsResponse");
                            v2 = new HomeViewState.Content(HomeViewModel.access$computeUiState(this.this$0, builtHomeCardsResponse));
                        } else if (var4_5 instanceof NetworkResponse.UnknownError) {
                            v2 = HomeViewState.Error.INSTANCE;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        v1.setValue((Object)v2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final List<CardState> computeUiState(HomeCardsResponse homeCardResponse) {
        block21: {
            result = new ArrayList<E>();
            teammateEnabled = this.config.isAccessToTeammateEnabled();
            var5_4 = homeCardResponse.getConversations();
            Intrinsics.checkNotNullExpressionValue(var5_4, (String)"homeCardResponse.conversations");
            conversationsInLastThreeDays = ConversationListExtensionsKt.filterRecentConversations(var5_4, this.timeProvider.currentTimeMillis(), this.config.isPreventMultipleInboundConversationsEnabled());
            if (homeCardResponse.hasMoreConversations()) ** GOTO lbl-1000
            var6_7 = homeCardResponse.getConversations();
            Intrinsics.checkNotNullExpressionValue(var6_7, (String)"homeCardResponse.conversations");
            if (((Collection)var6_7).isEmpty() == false) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = areThereAnyConversations = false;
            }
            if (((Collection)conversationsInLastThreeDays).isEmpty() == false) {
                showAllConversationsVisibility = conversationsInLastThreeDays.size() < homeCardResponse.getConversations().size() || homeCardResponse.hasMoreConversations() != false;
                result.add(new CardState.ConversationHistoryCard(conversationsInLastThreeDays, showAllConversationsVisibility));
            } else if (areThereAnyConversations) {
                block20: {
                    showAllConversationsVisibility = homeCardResponse.getCards();
                    Intrinsics.checkNotNullExpressionValue(showAllConversationsVisibility, (String)"homeCardResponse.cards");
                    $this$none$iv = showAllConversationsVisibility;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v1 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (HomeCard)element$iv;
                            $i$a$-none-HomeViewModel$computeUiState$1 = false;
                            if (!(it.getSlotType() == HomeCardSlotType.NEW_CONVERSATION)) continue;
                            v1 = false;
                            break block20;
                        }
                        v1 = true;
                    }
                }
                if (v1) {
                    result.add(CardState.ShowPreviousConversationsCard.INSTANCE);
                }
            }
            $this$any$iv = result;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (CardState)element$iv;
                    $i$a$-any-HomeViewModel$computeUiState$wasConversationHistoryCardAdded$1 = false;
                    if (!(it instanceof CardState.ConversationHistoryCard)) continue;
                    v2 = true;
                    break block21;
                }
                v2 = false;
            }
        }
        wasConversationHistoryCardAdded = v2;
        $this$any$iv = homeCardResponse.getCards();
        Intrinsics.checkNotNullExpressionValue($this$any$iv, (String)"homeCardResponse.cards");
        $this$forEach$iv = $this$any$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (HomeCard)element$iv;
            $i$a$-forEach-HomeViewModel$computeUiState$2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getSlotType().ordinal()]) {
                case 1: {
                    isFirstCard = result.isEmpty();
                    v3 = teammateEnabled ? (areThereAnyConversations ? R.string.intercom_start_another_conversation : R.string.intercom_start_a_conversation) : (var14_22 = R.string.intercom_how_can_we_help);
                    if (teammateEnabled) {
                        var15_24 = this.teamPresence.getExpectedResponseDelayHeader();
                        Intrinsics.checkNotNullExpressionValue((Object)var15_24, (String)"teamPresence.expectedResponseDelayHeader");
                        v4 = var15_24;
                        var15_24 = this.teamPresence.getExpectedResponseDelayDetails();
                        Intrinsics.checkNotNullExpressionValue((Object)var15_24, (String)"teamPresence.expectedResponseDelayDetails");
                        v5 = new CardState.NewConversationCard.TeammateExpectedResponseDelay(v4, var15_24);
                    } else {
                        v5 = new CardState.NewConversationCard.BotExpectedResponseDelay(R.string.intercom_tell_us_what_you_need);
                    }
                    var16_25 = v5;
                    var15_23 = teammateEnabled != false ? R.string.intercom_send_us_a_message : R.string.intercom_ask_a_question;
                    var17_26 = teammateEnabled != false ? R.drawable.intercom_send : R.drawable.intercom_conversation_card_question;
                    var18_28 /* !! */  = homeCardResponse.getConversations();
                    Intrinsics.checkNotNullExpressionValue(var18_28 /* !! */ , (String)"homeCardResponse.conversations");
                    v6 = var18_28 /* !! */ ;
                    var18_28 /* !! */  = this.store.state().unreadConversationIds();
                    Intrinsics.checkNotNullExpressionValue(var18_28 /* !! */ , (String)"store.state().unreadConversationIds()");
                    var19_29 = ConversationListExtensionsKt.hasOlderUnreadConversations(v6, CollectionsKt.toList((Iterable)var18_28 /* !! */ ));
                    var18_27 = wasConversationHistoryCardAdded == false && areThereAnyConversations != false;
                    var20_30 = isFirstCard != false ? CardState.NewConversationCard.NewConversationButtonStyle.FILLED : CardState.NewConversationCard.NewConversationButtonStyle.OUTLINE;
                    result.add(new CardState.NewConversationCard(var14_22, teammateEnabled, var16_25, var15_23, var17_26, var18_27, var19_29, var20_30));
                    break;
                }
                case 2: {
                    this.metricTracker.viewedSearchBrowseCard(result.size());
                    var13_21 = homeCardResponse.getArticleSuggestions();
                    Intrinsics.checkNotNullExpressionValue(var13_21, (String)"homeCardResponse.articleSuggestions");
                    result.add(new CardState.ArticleSearchCard(var13_21));
                    break;
                }
                case 3: {
                    result.add(new CardState.MessengerAppCard(it.getFallbackUrl()));
                }
            }
        }
        return result;
    }

    public final void onRealTimeEvent(@NotNull List<? extends Conversation> conversations) {
        Intrinsics.checkNotNullParameter(conversations, (String)"conversations");
        HomeViewState currentState = (HomeViewState)this._viewState.getValue();
        if (currentState instanceof HomeViewState.Content) {
            CardState.ConversationHistoryCard conversationHistoryCard;
            Object v0;
            List newState;
            block3: {
                newState = CollectionsKt.toMutableList((Collection)((HomeViewState.Content)currentState).getCards());
                for (Object t : (Iterable)newState) {
                    CardState it = (CardState)t;
                    boolean bl = false;
                    if (!(it instanceof CardState.ConversationHistoryCard)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            CardState currentConversationHistoryCard = v0;
            CardState.ConversationHistoryCard conversationHistoryCard2 = conversationHistoryCard = currentConversationHistoryCard instanceof CardState.ConversationHistoryCard ? (CardState.ConversationHistoryCard)currentConversationHistoryCard : null;
            if (conversationHistoryCard2 != null) {
                CardState.ConversationHistoryCard it = conversationHistoryCard2;
                boolean bl = false;
                newState.remove(conversationHistoryCard);
                newState.add(0, CardState.ConversationHistoryCard.copy$default(conversationHistoryCard, ConversationListExtensionsKt.filterRecentConversations(conversations, this.timeProvider.currentTimeMillis(), this.config.isPreventMultipleInboundConversationsEnabled()), false, 2, null));
                this._viewState.setValue((Object)new HomeViewState.Content(newState));
            }
        }
    }

    public static final /* synthetic */ MutableStateFlow access$get_viewState$p(HomeViewModel $this) {
        return $this._viewState;
    }

    public static final /* synthetic */ MessengerApi access$getMessengerApi$p(HomeViewModel $this) {
        return $this.messengerApi;
    }

    public static final /* synthetic */ Store access$getStore$p(HomeViewModel $this) {
        return $this.store;
    }

    public static final /* synthetic */ List access$computeUiState(HomeViewModel $this, HomeCardsResponse homeCardResponse) {
        return $this.computeUiState(homeCardResponse);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\r\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/homescreen/HomeViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/homescreen/HomeViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "factory", "io/intercom/android/sdk/homescreen/HomeViewModel$Companion$factory$1", "()Lio/intercom/android/sdk/homescreen/HomeViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HomeViewModel create(@NotNull ViewModelStoreOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            ViewModel viewModel2 = new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory()).get(HomeViewModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)viewModel2, (String)"ViewModelProvider(\n     \u2026omeViewModel::class.java)");
            return (HomeViewModel)viewModel2;
        }

        private final factory.1 factory() {
            return new ViewModelProvider.Factory(){

                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    MessengerApi messengerApi = Injector.get().getMessengerApi();
                    TimeProvider timeProvider = Injector.get().getTimeProvider();
                    Store<State> store = Injector.get().getStore();
                    MetricTracker metricTracker = Injector.get().getMetricTracker();
                    AppConfig appConfig = Injector.get().getAppConfigProvider().get();
                    TeamPresence teamPresence = Injector.get().getStore().state().teamPresence();
                    Intrinsics.checkNotNullExpressionValue((Object)messengerApi, (String)"messengerApi");
                    Intrinsics.checkNotNullExpressionValue((Object)timeProvider, (String)"timeProvider");
                    Intrinsics.checkNotNullExpressionValue(store, (String)"store");
                    Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"get()");
                    Intrinsics.checkNotNullExpressionValue((Object)teamPresence, (String)"teamPresence()");
                    Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"metricTracker");
                    return (T)((Object)new HomeViewModel(messengerApi, timeProvider, store, appConfig, teamPresence, metricTracker, null, 64, null));
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HomeCardSlotType.values().length];
            nArray[HomeCardSlotType.NEW_CONVERSATION.ordinal()] = 1;
            nArray[HomeCardSlotType.ARTICLE_SEARCH.ordinal()] = 2;
            nArray[HomeCardSlotType.MESSENGER_APP.ordinal()] = 3;
            nArray[HomeCardSlotType.UNKNOWN_CARD.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

