/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import coil.request.ImageRequest;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/conversation/composer/galleryinput/GalleryImageLoader;", "Lcom/intercom/composer/ImageLoader;", "()V", "clear", "", "imageView", "Landroid/widget/ImageView;", "getBitmapFromDrawable", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "getBitmapFromView", "loadImageIntoView", "image", "Lcom/intercom/input/gallery/GalleryImage;", "view", "Companion", "intercom-sdk-base_release"})
public final class GalleryImageLoader
implements ImageLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void loadImageIntoView(@NotNull GalleryImage image, @NotNull ImageView view) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String previewPath = image.getPreviewPath();
        Uri imageUri = TextUtils.isEmpty((CharSequence)previewPath) ? image.getUri() : Uri.parse((String)previewPath);
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        ImageRequest imageRequest = new ImageRequest.Builder(context).data((Object)imageUri).target(view).crossfade(true).placeholder((Drawable)new ColorDrawable(ContextCompat.getColor((Context)context, (int)R.color.intercom_search_bg_grey))).build();
        IntercomCoilKt.loadIntercomImage(context, imageRequest);
    }

    public void clear(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        IntercomCoilKt.clearIntercomImage(imageView);
    }

    @Nullable
    public Bitmap getBitmapFromView(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 instanceof TransitionDrawable) {
            int n = ((TransitionDrawable)drawable2).getNumberOfLayers() - 1;
            if (0 <= n) {
                do {
                    int i = n--;
                    Drawable drawable3 = ((TransitionDrawable)drawable2).getDrawable(i);
                    Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"drawable.getDrawable(i)");
                    Bitmap realBitmap = this.getBitmapFromDrawable(drawable3);
                    if (realBitmap == null) continue;
                    return realBitmap;
                } while (0 <= n);
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"drawable");
        return this.getBitmapFromDrawable(drawable2);
    }

    private final Bitmap getBitmapFromDrawable(Drawable drawable2) {
        return drawable2 instanceof BitmapDrawable ? ((BitmapDrawable)drawable2).getBitmap() : (Bitmap)null;
    }

    @JvmStatic
    @NotNull
    public static final GalleryImageLoader create() {
        return Companion.create();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lio/intercom/android/sdk/conversation/composer/galleryinput/GalleryImageLoader$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/conversation/composer/galleryinput/GalleryImageLoader;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GalleryImageLoader create() {
            return new GalleryImageLoader();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

