/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.intercom.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.AutoValue_Attribute;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class Attribute
implements Parcelable {
    private static final String STRING_TYPE = "string";
    private static final String INTEGER_TYPE = "integer";
    private static final String FLOAT_TYPE = "float";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String DATE_TYPE = "date";
    public static final Attribute NULL = Attribute.create("", "", "", "", "");
    public static final Parcelable.Creator<Attribute> CREATOR = new Parcelable.Creator<Attribute>(){

        public Attribute createFromParcel(Parcel in) {
            ArrayList<String> options = new ArrayList<String>();
            in.readList(options, String.class.getClassLoader());
            return Attribute.create(in.readString(), in.readString(), in.readString(), in.readString(), in.readString(), options);
        }

        public Attribute[] newArray(int size) {
            return new Attribute[size];
        }
    };

    static Attribute create(String customBotId, String identifier, String name, String type, String value) {
        return new AutoValue_Attribute(customBotId, identifier, name, type, value, Collections.emptyList());
    }

    static Attribute create(String customBotId, String identifier, String name, String type, String value, List<String> options) {
        return new AutoValue_Attribute(customBotId, identifier, name, type, value, options);
    }

    public abstract String getCustomBotControlId();

    public abstract String getIdentifier();

    public abstract String getName();

    public abstract String getType();

    public abstract String getValue();

    public abstract List<String> getOptions();

    public boolean hasValue() {
        return !TextUtils.isEmpty((CharSequence)this.getValue());
    }

    public String getRenderType() {
        switch (this.getType()) {
            case "string": {
                if (!this.getOptions().isEmpty()) {
                    return "list";
                }
                if ("email".equals(this.getIdentifier())) {
                    return "email";
                }
                if ("phone".equals(this.getIdentifier())) {
                    return "phone";
                }
                if ("company.website".equals(this.getIdentifier())) {
                    return "company.website";
                }
                return "text";
            }
            case "integer": {
                return "number";
            }
            case "float": {
                return FLOAT_TYPE;
            }
            case "boolean": {
                return BOOLEAN_TYPE;
            }
            case "date": {
                return DATE_TYPE;
            }
        }
        return "unknown";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.getOptions());
        dest.writeString(this.getCustomBotControlId());
        dest.writeString(this.getIdentifier());
        dest.writeString(this.getName());
        dest.writeString(this.getType());
        dest.writeString(this.getValue());
    }

    public static final class Builder {
        @Nullable
        String custom_bot_control_id;
        @Nullable
        String identifier;
        @Nullable
        String name;
        @Nullable
        String type;
        @Nullable
        String value;
        @Nullable
        List<String> options;

        public Builder withCustomBotControlId(String customBotControlId) {
            this.custom_bot_control_id = customBotControlId;
            return this;
        }

        public Builder withIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withOptions(List<String> options) {
            this.options = options;
            return this;
        }

        public Attribute build() {
            ArrayList<String> optionList = new ArrayList<String>(CollectionUtils.capacityFor(this.options));
            if (this.options != null) {
                for (String option : this.options) {
                    if (option == null) continue;
                    optionList.add(option);
                }
            }
            return Attribute.create(NullSafety.valueOrEmpty(this.custom_bot_control_id), NullSafety.valueOrEmpty(this.identifier), NullSafety.valueOrEmpty(this.name), NullSafety.valueOrEmpty(this.type), NullSafety.valueOrEmpty(this.value), optionList);
        }
    }
}

