/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;

public class ColorUtils {
    private static final float BRIGHTNESS_CUTOFF = 0.7f;
    private static final float ACCESSIBILITY_BRIGHTNESS_CUTOFF = 0.6f;
    private static final double ACCESSIBILITY_CONTRAST_RATIO = 3.0;
    private static final char COLOR_PREFIX = '#';
    private static final String SHORT_COLOR_REGEX = String.format("%s([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])", Character.valueOf('#'));
    private static final int SHORT_COLOR_WITH_PREFIX_LENGTH = 4;

    public static boolean isColorLight(String color2) {
        double luminance = androidx.core.graphics.ColorUtils.calculateLuminance((int)Color.parseColor((String)color2));
        return luminance > (double)0.7f;
    }

    public static boolean isColorLight(@ColorInt int color2) {
        double luminance = androidx.core.graphics.ColorUtils.calculateLuminance((int)color2);
        return luminance > (double)0.6f;
    }

    public static boolean isComparedColorsLowerThanAccessibilityContrastRatio(@ColorInt int foreground, @ColorInt int background) {
        return androidx.core.graphics.ColorUtils.calculateContrast((int)foreground, (int)background) < 3.0;
    }

    public static int lightenColor(int color2) {
        int resultR = (Color.red((int)color2) + 255) / 2;
        int resultG = (Color.green((int)color2) + 255) / 2;
        int resultB = (Color.blue((int)color2) + 255) / 2;
        return Color.argb((int)Color.alpha((int)color2), (int)resultR, (int)resultG, (int)resultB);
    }

    private static int lightenColor(int color2, float value) {
        float[] hsl = new float[3];
        androidx.core.graphics.ColorUtils.colorToHSL((int)color2, (float[])hsl);
        hsl[2] = hsl[2] + value;
        hsl[2] = Math.max(0.0f, Math.min(hsl[2], 1.0f));
        return androidx.core.graphics.ColorUtils.HSLToColor((float[])hsl);
    }

    public static int darkenColor(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = hsv[2] * 0.79f;
        return Color.HSVToColor((float[])hsv);
    }

    private static int darkenColor(int color2, float value) {
        float[] hsl = new float[3];
        androidx.core.graphics.ColorUtils.colorToHSL((int)color2, (float[])hsl);
        hsl[2] = hsl[2] - value;
        hsl[2] = Math.max(0.0f, Math.min(hsl[2], 1.0f));
        return androidx.core.graphics.ColorUtils.HSLToColor((float[])hsl);
    }

    public static int buttonTextColorVariant(int color2) {
        float[] hsl = new float[3];
        androidx.core.graphics.ColorUtils.colorToHSL((int)color2, (float[])hsl);
        float lightness = hsl[2];
        float darkenFactor = lightness - 0.3f;
        if ((double)lightness > 0.9) {
            return ColorUtils.darkenColor(color2, darkenFactor);
        }
        if ((double)lightness < 0.35) {
            return color2;
        }
        return ColorUtils.darkenColor(color2, darkenFactor);
    }

    public static int buttonBackgroundColorVariant(int color2) {
        float[] hsl = new float[3];
        androidx.core.graphics.ColorUtils.colorToHSL((int)color2, (float[])hsl);
        float lightness = hsl[2];
        float lightenFactor = 0.95f - lightness;
        float mildlyDarkenFactor = lightness - 0.85f;
        if ((double)lightness > 0.9) {
            return ColorUtils.darkenColor(color2, mildlyDarkenFactor);
        }
        if ((double)lightness < 0.35) {
            return ColorUtils.lightenColor(color2, lightenFactor);
        }
        return ColorUtils.lightenColor(color2, lightenFactor);
    }

    public static ColorFilter newGreyscaleFilter() {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        return new ColorMatrixColorFilter(colorMatrix);
    }

    public static void setTextColorWhiteOrBlack(TextView textView, boolean shouldRenderDarkText) {
        int textColor = ColorUtils.whiteOrBlackColor(textView.getContext(), shouldRenderDarkText);
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    public static void setTextColorWhiteOrDark(TextView textView, boolean shouldRenderDarkText) {
        int textColor = ColorUtils.whiteOrDarkColor(textView.getContext(), shouldRenderDarkText);
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    public static void setTextColorPrimaryOrDark(TextView textView, AppConfig appConfig) {
        int textColor = ColorUtils.primaryOrDarkColor(textView.getContext(), appConfig);
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    public static void setTextColorPrimaryOrBlack(TextView textView, AppConfig appConfig) {
        int textColor = ColorUtils.primaryOrBlackColor(textView.getContext(), appConfig);
        textView.setTextColor(textColor);
        textView.setLinkTextColor(textColor);
    }

    @ColorInt
    public static int primaryOrGreyAccessibility(Context context, AppConfig appConfig) {
        return ColorUtils.isColorLight(appConfig.getPrimaryColor()) ? ContextCompat.getColor((Context)context, (int)R.color.intercom_accessibility_grey) : appConfig.getPrimaryColor();
    }

    @ColorInt
    public static int primaryOrBlackAccessibility(Context context, AppConfig appConfig) {
        return ColorUtils.isColorLight(appConfig.getPrimaryColor()) ? ContextCompat.getColor((Context)context, (int)R.color.intercom_accessibility_black) : appConfig.getPrimaryColor();
    }

    @ColorInt
    public static int whiteOrBlackAccessibility(Context context, AppConfig appConfig) {
        return ColorUtils.isColorLight(appConfig.getPrimaryColor()) ? ContextCompat.getColor((Context)context, (int)R.color.intercom_accessibility_black) : ContextCompat.getColor((Context)context, (int)R.color.intercom_white);
    }

    @ColorInt
    public static int primaryOrDarkColor(Context context, AppConfig appConfig) {
        return appConfig.primaryColorRenderDarkText() ? ContextCompat.getColor((Context)context, (int)ColorUtils.darkColorRes()) : appConfig.getPrimaryColor();
    }

    public static Drawable getCloseBackground(Context requireContext, AppConfig appConfig) {
        return appConfig.primaryColorRenderDarkText() ? ContextCompat.getDrawable((Context)requireContext, (int)R.drawable.intercom_transparent_dark_circle) : ContextCompat.getDrawable((Context)requireContext, (int)R.drawable.intercom_transparent_light_circle);
    }

    @ColorInt
    private static int primaryOrBlackColor(Context context, AppConfig appConfig) {
        return appConfig.primaryColorRenderDarkText() ? ContextCompat.getColor((Context)context, (int)R.color.intercom_black) : appConfig.getPrimaryColor();
    }

    @ColorInt
    public static int whiteOrDarkColor(Context context, boolean shouldRenderDarkText) {
        return shouldRenderDarkText ? ContextCompat.getColor((Context)context, (int)ColorUtils.darkColorRes()) : ContextCompat.getColor((Context)context, (int)R.color.intercom_white);
    }

    @ColorInt
    public static int whiteOrBlackColor(Context context, boolean shouldRenderDarkText) {
        return ContextCompat.getColor((Context)context, (int)(shouldRenderDarkText ? R.color.intercom_accessibility_black : R.color.intercom_white));
    }

    public static void setImageColorWhiteOrBlack(ImageView view, boolean shouldRenderDarkImage) {
        int imageColor = ColorUtils.whiteOrBlackColor(view.getContext(), shouldRenderDarkImage);
        view.setColorFilter(imageColor);
    }

    public static void setImageSrcColorWhiteOrDark(ImageView view, boolean shouldRenderDarkImage) {
        int imageColorRes = shouldRenderDarkImage ? ColorUtils.darkColorRes() : R.color.intercom_white;
        int imageColor = ContextCompat.getColor((Context)view.getContext(), (int)imageColorRes);
        Drawable drawable2 = view.getDrawable();
        if (drawable2 != null) {
            drawable2.setColorFilter(imageColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public static void updateInnerBorderColor(AppConfig appConfig, View view) {
        int primaryColor = appConfig.getPrimaryColor();
        LayerDrawable cardBackgroundDrawable = (LayerDrawable)ContextCompat.getDrawable((Context)view.getContext(), (int)R.drawable.intercom_conversation_card_with_top_border);
        Drawable topBorderDrawable = cardBackgroundDrawable.findDrawableByLayerId(R.id.top_border);
        topBorderDrawable.setAlpha(127);
        topBorderDrawable.setColorFilter(primaryColor, PorterDuff.Mode.SRC_IN);
        BackgroundUtils.setBackground(view, (Drawable)cardBackgroundDrawable);
    }

    public static void updateLeftDrawableColorAccordingToBrightness(TextView view, @ColorInt int color2) {
        int newColor = color2;
        if (ColorUtils.isColorLight(color2)) {
            newColor = ContextCompat.getColor((Context)view.getContext(), (int)R.color.intercom_accessibility_black);
        }
        ColorUtils.updateLeftDrawableColor(view, newColor);
    }

    public static void updateLeftDrawableColorAccordingToContrast(TextView view, @ColorInt int colorInFocus, @ColorInt int backgroundColor) {
        int newColor = colorInFocus;
        if (ColorUtils.isComparedColorsLowerThanAccessibilityContrastRatio(colorInFocus, backgroundColor)) {
            if (ColorUtils.isColorLight(colorInFocus)) {
                ContextCompat.getColor((Context)view.getContext(), (int)R.color.intercom_accessibility_black);
            } else {
                ContextCompat.getColor((Context)view.getContext(), (int)R.color.intercom_white);
            }
        }
        ColorUtils.updateLeftDrawableColor(view, newColor);
    }

    public static void updateLeftDrawableColor(TextView view, @ColorInt int color2) {
        for (Drawable drawable2 : view.getCompoundDrawables()) {
            if (drawable2 == null) continue;
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
        for (Drawable drawable2 : view.getCompoundDrawablesRelative()) {
            if (drawable2 == null) continue;
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
    }

    @ColorInt
    public static int parseColor(@NonNull String color2) {
        if (color2.length() == 4 && color2.charAt(0) == '#') {
            color2 = color2.replaceAll(SHORT_COLOR_REGEX, String.format("%s$1$1$2$2$3$3", Character.valueOf('#')));
        }
        return Color.parseColor((String)color2);
    }

    @ColorRes
    private static int darkColorRes() {
        return R.color.intercom_accessibility_black;
    }
}

