/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.widget.Toolbar;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryInputDataSource;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryLightBoxFragment;
import com.intercom.input.gallery.LocalImagesDataSource;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.galleryinput.GalleryImageLoader;
import io.intercom.android.sdk.conversation.composer.galleryinput.LocalGalleryLightBoxFragment;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.util.Arrays;
import java.util.List;

class LocalGalleryInputInjector
implements GalleryInputFragment.Injector {
    @Nullable
    public View getExpanderButton(ViewGroup parent) {
        ImageButton expander = (ImageButton)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.intercom_expander_button, parent, false);
        expander.setColorFilter(this.getThemeColor(expander.getContext()));
        return expander;
    }

    @Nullable
    public View getSearchView(ViewGroup parent) {
        return null;
    }

    public Toolbar getToolbar(ViewGroup parent) {
        return (Toolbar)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.intercom_gallery_input_toolbar, parent, false);
    }

    public int getThemeColor(Context context) {
        AppConfig appConfig = Injector.get().getAppConfigProvider().get();
        return ColorUtils.primaryOrDarkColor(context, appConfig);
    }

    public GalleryInputDataSource getDataSource(GalleryInputFragment fragment) {
        String appId = Injector.get().getAppIdentity().appId();
        return LocalImagesDataSource.create((GalleryInputFragment)fragment, (boolean)this.shouldShowVideo(appId));
    }

    public ImageLoader getImageLoader(GalleryInputFragment fragment) {
        return GalleryImageLoader.create();
    }

    public Class<? extends GalleryLightBoxFragment> getLightBoxFragmentClass(GalleryInputFragment fragment) {
        return LocalGalleryLightBoxFragment.class;
    }

    public String getEmptyViewTitle(Resources resources) {
        return resources.getString(R.string.intercom_no_photos);
    }

    public String getEmptyViewSubtitle(Resources resources) {
        return resources.getString(R.string.intercom_no_photos_on_device);
    }

    public String getErrorViewTitle(Resources resources) {
        return null;
    }

    public String getErrorViewSubtitle(Resources resources) {
        return null;
    }

    @VisibleForTesting
    boolean shouldShowVideo(String appId) {
        List<String> appsToEnableVideoUpload = Arrays.asList("odymwnr8", "ruozuwky");
        return appsToEnableVideoUpload.contains(appId);
    }
}

