/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.helpcenter.articles.ArticleStatsArguments;
import io.intercom.android.sdk.helpcenter.collections.IntercomHelpCenterActivity;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.homescreen.HomeFragment;
import io.intercom.android.sdk.inbox.InboxFragment;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import java.util.Collections;
import java.util.List;

public class IntercomMessengerActivity
extends IntercomBaseActivity
implements InboxFragment.Listener,
ConversationFragment.Listener,
HomeClickListener {
    @VisibleForTesting
    static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @VisibleForTesting
    static final String PARCEL_INITIAL_MESSAGE = "parcel_initial_message";
    @VisibleForTesting
    ValueAnimator colorAnimation;
    static final String SHOW_HOME_SCREEN = "showHomeScreen";
    static final String SHOW_INBOX = "showInbox";
    static final String ARTICLE_ARGS = "articleArgs";
    static final String LAST_PARTICIPANT = "last_participant";
    private HomeFragment homeFragment;
    private InboxFragment inboxFragment;
    private View containerView;
    View background;
    private Store<State> store;
    private MetricTracker metricTracker;
    private final Twig twig = LumberMill.getLogger();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_messenger_activity_layout);
        this.homeFragment = HomeFragment.newInstance();
        this.inboxFragment = new InboxFragment();
        this.containerView = this.findViewById(R.id.messenger_container);
        if (this.containerView != null) {
            this.containerView.setVisibility(8);
        }
        this.getFragmentManager().executePendingTransactions();
        this.showMessenger();
        Injector injector = Injector.get();
        this.metricTracker = injector.getMetricTracker();
        this.store = injector.getStore();
    }

    protected void onResume() {
        super.onResume();
        this.store.dispatch(Actions.messengerOpened());
    }

    protected void onPause() {
        super.onPause();
        this.store.dispatch(Actions.messengerClosed());
    }

    private int getScreenHeight() {
        return this.findViewById(0x1020002).getMeasuredHeight();
    }

    private void showMessenger() {
        Bundle data = this.getIntent().getExtras();
        String conversationId = "";
        String initialMessage = "";
        LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        boolean shouldShowHomeScreen = false;
        boolean shouldShowInbox = false;
        ArticleStatsArguments articleArgs = new ArticleStatsArguments();
        if (data != null) {
            data.setClassLoader(Part.class.getClassLoader());
            conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
            initialMessage = data.getString(PARCEL_INITIAL_MESSAGE, "");
            shouldShowHomeScreen = data.getBoolean(SHOW_HOME_SCREEN);
            shouldShowInbox = data.getBoolean(SHOW_INBOX);
            if (data.containsKey(ARTICLE_ARGS)) {
                articleArgs = (ArticleStatsArguments)data.getParcelable(ARTICLE_ARGS);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        if (shouldShowHomeScreen) {
            this.displayFragment(this.homeFragment, HomeFragment.class.getName(), false);
        } else if (shouldShowInbox) {
            this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), false);
        } else {
            this.displayConversation(conversationId, lastParticipatingAdmin, false, false, initialMessage, articleArgs);
        }
        this.animateBackgroundColor();
    }

    private void animateBackgroundColor() {
        this.background = this.getWindow().getDecorView();
        BackgroundUtils.animateBackground(ContextCompat.getColor((Context)this, (int)17170445), ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black), 200, this.background, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.background.post(new Runnable(){

                    @Override
                    public void run() {
                        IntercomMessengerActivity.this.animateSdkWindowIn();
                    }
                });
            }
        });
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        this.twig.internal("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        int fragmentId = R.id.inbox_fragment;
        transaction.replace(fragmentId, frag, tag);
        if (addToBackStack) {
            this.twig.internal("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(tag);
        }
        transaction.commitAllowingStateLoss();
    }

    public void onBackPressed() {
        ConversationFragment fragment = this.getExistingConversationFragment();
        if (fragment != null && fragment.shouldHandleOnBackPressed()) {
            fragment.handleOnBackPressed();
        } else {
            this.applyBackOrCloseMessenger();
        }
    }

    private void applyBackOrCloseMessenger() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
            this.metricTracker.closedMessengerBackButton();
            this.closeMessenger();
        } else {
            this.trackMoveToConversationListMetric();
            this.hideKeyboard();
            super.onBackPressed();
        }
    }

    private void trackMoveToConversationListMetric() {
        ConversationFragment fragment = this.getExistingConversationFragment();
        if (fragment != null) {
            String conversationId = fragment.getConversationId();
            if (TextUtils.isEmpty((CharSequence)conversationId)) {
                this.metricTracker.openConversationsListFromNewConversation();
            } else {
                this.metricTracker.openConversationsListFromConversation(conversationId);
            }
        }
    }

    @Nullable
    ConversationFragment getExistingConversationFragment() {
        String tag = ConversationFragment.class.getName();
        return (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(tag);
    }

    @Override
    public void onConversationSelected(Conversation conversation) {
        LastParticipatingAdmin lastParticipatingAdmin = this.getLastParticipatingAdmin(conversation);
        TimeFormatter timeFormatter = new TimeFormatter((Context)this, Injector.get().getTimeProvider());
        this.displayConversation(conversation.getId(), lastParticipatingAdmin, conversation.isRead(), true, "", conversation.getGroupConversationParticipants(), new ArticleStatsArguments());
        this.metricTracker.openConversationFromConversationList(conversation.getId(), Injector.get().getStore().state().teamPresence().getOfficeHours().isEmpty(), lastParticipatingAdmin.isActive(), timeFormatter.getLastActiveMinutes(lastParticipatingAdmin.getLastActiveAt()));
    }

    private void displayConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack, String initialMessage, ArticleStatsArguments articleArgs) {
        this.displayConversation(conversationId, participant, isRead, addToBackStack, initialMessage, Collections.emptyList(), articleArgs);
    }

    private void displayConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack, String initialMessage, List<Participant> groupParticipants, ArticleStatsArguments articleArgs) {
        ConversationFragment fragment = ConversationFragment.newInstance(conversationId, participant, isRead, initialMessage, groupParticipants, "", articleArgs);
        this.displayFragment(fragment, ConversationFragment.class.getName(), addToBackStack);
    }

    void animateSdkWindowIn() {
        this.containerView.setVisibility(0);
        this.containerView.setY((float)this.getScreenHeight());
        this.containerView.animate().y(0.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).setDuration(350L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.hideBackgroundColor();
                ConversationFragment fragment = IntercomMessengerActivity.this.getExistingConversationFragment();
                if (fragment != null) {
                    fragment.sdkWindowFinishedAnimating();
                }
            }
        }).start();
    }

    private void closeMessenger() {
        this.hideKeyboard();
        this.showBackgroundColour();
        this.containerView.animate().y((float)this.getWindow().getDecorView().getHeight()).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(600L).start();
        this.fadeOutBackground();
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void fadeOutBackground() {
        int colorTo = ContextCompat.getColor((Context)this, (int)17170445);
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black);
        this.colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        this.colorAnimation.setDuration(300L);
        this.colorAnimation.setStartDelay(100L);
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                IntercomMessengerActivity.this.background.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.finish();
                IntercomMessengerActivity.this.overridePendingTransition(0, 0);
            }
        });
        this.colorAnimation.start();
    }

    @Override
    public void onToolbarCloseClicked() {
        this.metricTracker.closedMessengerCloseButton();
        this.closeMessenger();
    }

    @Override
    public void onBackClicked() {
        if (this.hasLoadedFragment(HomeFragment.class.getName())) {
            this.applyBackOrCloseMessenger();
        } else {
            this.trackMoveToConversationListMetric();
            this.hideKeyboard();
            this.displayFragment(this.homeFragment, HomeFragment.class.getName(), false);
        }
    }

    @Override
    public void onStartAnotherConversation(String closedConversationId) {
        ConversationFragment fragment = ConversationFragment.newInstance("", LastParticipatingAdmin.NULL, false, "", Collections.emptyList(), closedConversationId, null);
        this.displayFragment(fragment, ConversationFragment.class.getName(), false);
    }

    private void showBackgroundColour() {
        this.background.setBackgroundResource(R.color.intercom_transparent_black);
    }

    void hideBackgroundColor() {
        this.background.setBackgroundResource(R.color.intercom_full_transparent_full_black);
    }

    public static Intent openHomeScreen(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_HOME_SCREEN, true);
    }

    public static Intent openInbox(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, true);
    }

    public static Intent openComposer(Context context, String initialMessage) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)initialMessage)) {
            intent.putExtra(PARCEL_INITIAL_MESSAGE, initialMessage);
        }
        return intent;
    }

    public static Intent openComposerFromArticle(Context context, ArticleStatsArguments articleArgs) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(ARTICLE_ARGS, (Parcelable)articleArgs).putExtra(SHOW_INBOX, false);
    }

    public static Intent openConversation(Context context, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        }
        intent.setExtrasClassLoader(LastParticipatingAdmin.class.getClassLoader());
        return intent;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.containerView.setY(0.0f);
        this.containerView.getLayoutParams().height = -1;
    }

    private boolean hasLoadedFragment(String fragmentTag) {
        return this.getSupportFragmentManager().findFragmentByTag(fragmentTag) != null;
    }

    private LastParticipatingAdmin getLastParticipatingAdmin(Conversation conversation) {
        LastParticipatingAdmin lastParticipatingAdmin = conversation.getLastParticipatingAdmin();
        if (LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            lastParticipatingAdmin = LastParticipatingAdmin.NONE;
        }
        return lastParticipatingAdmin;
    }

    @Override
    public void onNewConversationClicked() {
        this.metricTracker.openedNewConversationFromHomeScreen();
        ConversationFragment fragment = ConversationFragment.newInstance("", LastParticipatingAdmin.NULL, false, "", Collections.emptyList(), "", new ArticleStatsArguments());
        this.displayFragment(fragment, ConversationFragment.class.getName(), true);
    }

    @Override
    public void onSeePreviousClicked() {
        this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), true);
    }

    @Override
    public void onConversationClicked(Conversation conversation) {
        this.metricTracker.openedConversationFromHomeScreen(conversation.getId());
        ConversationFragment fragment = ConversationFragment.newInstance(conversation.getId(), this.getLastParticipatingAdmin(conversation), conversation.isRead(), "", conversation.getGroupConversationParticipants(), "", new ArticleStatsArguments());
        this.displayFragment(fragment, ConversationFragment.class.getName(), true);
    }

    @Override
    public void onCloseClicked() {
        this.finish();
    }

    @Override
    public void onArticleSearchClicked() {
        this.metricTracker.clickedSearchBrowseCard();
        this.startActivity(IntercomHelpCenterActivity.buildIntent((Context)this, Collections.emptyList(), "search_browse"));
    }
}

