/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib;

import android.view.View;
import android.view.ViewGroup;
import com.intercom.commons.utilities.HtmlCompat;
import io.intercom.android.sdk.blocks.lib.BlockTypeNotImplementedException;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.VideoProvider;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.lib.models.ConversationRating;
import io.intercom.android.sdk.blocks.lib.models.Image;
import io.intercom.android.sdk.blocks.lib.models.Link;
import io.intercom.android.sdk.blocks.lib.models.LinkList;
import java.util.Locale;

public enum BlockType {
    PARAGRAPH("paragraph"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getParagraph().addParagraph(HtmlCompat.fromHtml((String)block.getText()), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    HEADING("heading"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getHeading().addHeading(HtmlCompat.fromHtml((String)block.getText()), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    SUBHEADING("subheading"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getSubheading().addSubheading(HtmlCompat.fromHtml((String)block.getText()), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    CODE("code"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getCode().addCode(HtmlCompat.fromHtml((String)block.getText()), blockMetadata, layout2);
        }
    }
    ,
    LINK("link"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getLink().addLinkBlock(Link.fromBlock(block), blockMetadata, layout2);
        }
    }
    ,
    CONVERSATIONRATING("conversationRating"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getConversationRating().addConversationRatingBlock(ConversationRating.fromBlock(block), blockMetadata, layout2);
        }
    }
    ,
    LINKLIST("linkList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getLinkList().addLinkListBlock(LinkList.fromBlock(block), blockMetadata, layout2);
        }
    }
    ,
    UNORDEREDLIST("unorderedList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getUnorderedList().addUnorderedList(block.getItems(), blockMetadata, layout2);
        }
    }
    ,
    ORDEREDLIST("orderedList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getOrderedList().addOrderedList(block.getItems(), blockMetadata, layout2);
        }
    }
    ,
    ATTACHMENTLIST("attachmentList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getAttachmentList().addAttachmentList(block.getAttachments(), blockMetadata, layout2);
        }
    }
    ,
    IMAGE("image"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getImage().addImage(block.getUrl(), 11.getLinkUrl(block), block.getWidth(), block.getHeight(), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    IMAGETEXT("imageText"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            Image image = block.getImage();
            return viewHolder.getImageText().addImageText(HtmlCompat.fromHtml((String)block.getTitle()), HtmlCompat.fromHtml((String)block.getText()), block.getImageUrl(), block.getImageWidth(), block.getImageHeight(), blockMetadata, layout2);
        }
    }
    ,
    BUTTON("button"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getButton().addButton(HtmlCompat.fromHtml((String)block.getText()), 13.getLinkUrl(block), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    FACEBOOKLIKEBUTTON("facebookLikeButton"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getFacebookButton().addFacebookButton(block.getUrl(), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    TWITTERFOLLOWBUTTON("twitterFollowButton"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getTwitterButton().addTwitterButton("https://twitter.com/" + block.getUsername(), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    VIDEO("video"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getVideo().addVideo(block.getText(), VideoProvider.videoValueOf(block.getProvider()), block.getId(), blockMetadata, layout2);
        }
    }
    ,
    VIDEOFILE("videoFile"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getVideoFile().addVideoFile(block.getText(), block.getUrl(), block.getThumbnailUrl(), blockMetadata, layout2);
        }
    }
    ,
    MESSENGERCARD("messengerCard"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getMessengerCardBlock().addCard(block.getText(), block.getFallbackUrl(), blockMetadata, layout2);
        }
    }
    ,
    LOCALIMAGE("localImage"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getLocalImage().addImage(block.getUri(), block.getWidth(), block.getHeight(), block.getAlign(), blockMetadata, layout2);
        }
    }
    ,
    LOCAL_ATTACHMENT("local_attachment"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            return viewHolder.getLocalAttachment().addAttachment(block.getAttachments().get(0), blockMetadata, layout2);
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) {
            if (!block.getText().isEmpty() && viewHolder.getParagraph() != null) {
                return PARAGRAPH.generateViewFromBlockAndLayout(viewHolder, block, layout2, blockMetadata);
            }
            throw new BlockTypeNotImplementedException();
        }
    };

    private final String serializedName;

    private BlockType(String serializedName) {
        this.serializedName = serializedName;
    }

    abstract View generateViewFromBlockAndLayout(BlocksViewHolder var1, Block var2, ViewGroup var3, BlockMetadata var4);

    public String getSerializedName() {
        return this.serializedName;
    }

    public View getView(BlocksViewHolder viewHolder, Block block, ViewGroup layout2, BlockMetadata blockMetadata) throws BlockTypeNotImplementedException {
        try {
            return this.generateViewFromBlockAndLayout(viewHolder, block, layout2, blockMetadata);
        }
        catch (NullPointerException exception) {
            try {
                return UNKNOWN.generateViewFromBlockAndLayout(viewHolder, block, layout2, blockMetadata);
            }
            catch (BlockTypeNotImplementedException | NullPointerException e) {
                throw new BlockTypeNotImplementedException();
            }
        }
    }

    protected static String getLinkUrl(Block block) {
        return block.getTrackingUrl().isEmpty() ? block.getLinkUrl() : block.getTrackingUrl();
    }

    public static BlockType typeValueOf(String type) {
        BlockType blockType = UNKNOWN;
        try {
            blockType = BlockType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return blockType;
    }
}

