/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.logic.TextSplittingStrategy;
import java.util.ArrayList;
import java.util.List;

public class BlockFactory {
    private final TextSplittingStrategy textSplittingStrategy;

    public BlockFactory(TextSplittingStrategy textSplittingStrategy) {
        this.textSplittingStrategy = textSplittingStrategy;
    }

    public List<Block.Builder> getBlocksForText(String text) {
        List<String> rawParagraphs = this.textSplittingStrategy.apply(text);
        int size = rawParagraphs.size();
        ArrayList<Block.Builder> paragraphs = new ArrayList<Block.Builder>(size);
        for (int i = 0; i < size; ++i) {
            paragraphs.add(new Block.Builder().withType(BlockType.PARAGRAPH.name().toLowerCase()).withText(rawParagraphs.get(i)));
        }
        return paragraphs;
    }
}

