/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public enum NexusEvent {
    NewComment{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            event.put(NexusEvent.NX_TO_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_TO_USER);
        }
    }
    ,
    NewMessage{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            event.put(NexusEvent.NX_TO_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_TO_USER);
        }
    }
    ,
    CreateConversation{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            event.put(NexusEvent.NX_TO_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_TO_USER);
        }
    }
    ,
    ConversationSeen{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            event.put(NexusEvent.NX_FROM_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_FROM_USER);
        }
    }
    ,
    UserIsTyping{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            event.put(NexusEvent.NX_FROM_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_FROM_USER);
        }
    }
    ,
    AdminIsTyping{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            JSONObject eventData = event.optJSONObject(NexusEvent.EVENT_DATA);
            eventData.put(NexusEvent.ADMIN_NAME, (Object)this.getAdminName());
            eventData.put(NexusEvent.ADMIN_ID, (Object)this.getAdminId());
            event.put(NexusEvent.NX_TO_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_TO_USER);
            JSONObject eventData = jsonObject.optJSONObject(NexusEvent.EVENT_DATA);
            if (eventData != null) {
                ((NexusEvent)this).adminId = eventData.optString(NexusEvent.ADMIN_ID);
                ((NexusEvent)this).adminName = eventData.optString(NexusEvent.ADMIN_NAME);
                ((NexusEvent)this).adminAvatarUrl = eventData.optString(NexusEvent.ADMIN_AVATAR);
            }
        }
    }
    ,
    AdminIsTypingANote{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            JSONObject eventData = event.optJSONObject(NexusEvent.EVENT_DATA);
            eventData.put(NexusEvent.ADMIN_NAME, (Object)this.getAdminName());
            eventData.put(NexusEvent.ADMIN_ID, (Object)this.getAdminId());
            event.put(NexusEvent.NX_TO_USER, (Object)this.getUserId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).userId = jsonObject.optString(NexusEvent.NX_TO_USER);
            JSONObject eventData = jsonObject.optJSONObject(NexusEvent.EVENT_DATA);
            if (eventData != null) {
                ((NexusEvent)this).adminId = eventData.optString(NexusEvent.ADMIN_ID);
                ((NexusEvent)this).adminName = eventData.optString(NexusEvent.ADMIN_NAME);
                ((NexusEvent)this).adminAvatarUrl = eventData.optString(NexusEvent.ADMIN_AVATAR);
            }
        }
    }
    ,
    NewNote{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            JSONObject eventData = event.optJSONObject(NexusEvent.EVENT_DATA);
            eventData.put(NexusEvent.ADMIN_ID, (Object)this.getAdminId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).adminId = jsonObject.optJSONObject(NexusEvent.EVENT_DATA).optString(NexusEvent.ADMIN_ID);
        }
    }
    ,
    ConversationAssigned{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            JSONObject eventData = event.optJSONObject(NexusEvent.EVENT_DATA);
            eventData.put(NexusEvent.ADMIN_ID, (Object)this.getAdminId());
            eventData.put("assigneeId", (Object)this.getAssigneeId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).adminId = jsonObject.optJSONObject(NexusEvent.EVENT_DATA).optString(NexusEvent.ADMIN_ID);
            ((NexusEvent)this).assigneeId = jsonObject.optJSONObject(NexusEvent.EVENT_DATA).optString("assigneeId");
        }
    }
    ,
    ConversationClosed{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            JSONObject eventData = event.optJSONObject(NexusEvent.EVENT_DATA);
            eventData.put(NexusEvent.ADMIN_ID, (Object)this.getAdminId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).adminId = jsonObject.optJSONObject(NexusEvent.EVENT_DATA).optString(NexusEvent.ADMIN_ID);
        }
    }
    ,
    ConversationReopened{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = super.toJsonObject();
            JSONObject eventData = event.optJSONObject(NexusEvent.EVENT_DATA);
            eventData.put(NexusEvent.ADMIN_ID, (Object)this.getAdminId());
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            super.init(jsonObject);
            ((NexusEvent)this).adminId = jsonObject.optJSONObject(NexusEvent.EVENT_DATA).optString(NexusEvent.ADMIN_ID);
        }
    }
    ,
    UserPresence{

        @Override
        protected JSONObject toJsonObject() throws JSONException {
            JSONObject event = new JSONObject();
            JSONObject eventData = new JSONObject();
            event.put(NexusEvent.EVENT_GUID, (Object)UUID.randomUUID().toString());
            event.put(NexusEvent.EVENT_NAME, (Object)("nx." + this.name()));
            event.put(NexusEvent.EVENT_DATA, (Object)eventData);
            return event;
        }

        @Override
        protected void init(JSONObject jsonObject) {
            ((NexusEvent)this).guid = jsonObject.optString(NexusEvent.EVENT_GUID);
        }
    }
    ,
    UNKNOWN{

        @Override
        protected String toJsonFormattedString() {
            return "";
        }
    };

    private static final String EVENT_GUID = "eventGuid";
    private static final String EVENT_DATA = "eventData";
    private static final String EVENT_NAME = "eventName";
    private static final String ADMIN_NAME = "adminName";
    private static final String ADMIN_ID = "adminId";
    private static final String ADMIN_AVATAR = "adminAvatar";
    private static final String CONVERSATION_ID = "conversationId";
    private static final String NX_TO_USER = "nx.ToUser";
    private static final String NX_FROM_USER = "nx.FromUser";
    private String guid = "";
    private String adminId = "";
    private String adminName = "";
    private String userId = "";
    private String conversationId = "";
    private String assigneeId = "";
    private String adminAvatarUrl = "";

    protected String toJsonFormattedString() {
        try {
            return this.toJsonObject().toString();
        }
        catch (JSONException ignored) {
            return "";
        }
    }

    protected JSONObject toJsonObject() throws JSONException {
        JSONObject event = new JSONObject();
        JSONObject eventData = new JSONObject();
        eventData.put(CONVERSATION_ID, (Object)this.getConversationId());
        event.put(EVENT_GUID, (Object)UUID.randomUUID().toString());
        event.put(EVENT_NAME, (Object)this.name());
        event.put(EVENT_DATA, (Object)eventData);
        return event;
    }

    protected void init(JSONObject jsonObject) {
        this.guid = jsonObject.optString(EVENT_GUID);
        try {
            this.conversationId = jsonObject.getJSONObject(EVENT_DATA).optString(CONVERSATION_ID);
        }
        catch (JSONException e) {
            this.conversationId = jsonObject.optString(EVENT_DATA);
        }
    }

    public static NexusEvent parse(JSONObject response) {
        NexusEvent event;
        String name = response.optString(EVENT_NAME);
        try {
            if (name.startsWith("nx.")) {
                name = name.substring(3);
            }
            event = NexusEvent.valueOf(name);
            event.init(response);
        }
        catch (IllegalArgumentException e) {
            event = UNKNOWN;
        }
        return event;
    }

    public static NexusEvent getAdminIsTypingEvent(String conversationId, String adminId) {
        NexusEvent event = AdminIsTyping;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getAdminIsTypingNoteEvent(String conversationId, String adminId) {
        NexusEvent event = AdminIsTypingANote;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getUserIsTypingEvent(String conversationId, String userId) {
        NexusEvent event = UserIsTyping;
        event.userId = userId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getConversationSeenEvent(String conversationId, String userId) {
        NexusEvent event = ConversationSeen;
        event.userId = userId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getConversationSeenAdminEvent(String conversationId, String adminId) {
        NexusEvent event = ConversationSeen;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getNewCommentEvent(String conversationId, String userId) {
        NexusEvent event = NewComment;
        event.userId = userId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getNewAdminCommentEvent(String conversationId, String adminId) {
        NexusEvent event = NewComment;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getNewNoteEvent(String conversationId, String adminId) {
        NexusEvent event = NewNote;
        event.userId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getCreateConversationEvent(String conversationId, String userId) {
        NexusEvent event = CreateConversation;
        event.userId = userId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getConversationAssignedEvent(String conversationId, String adminId, String assigneeId) {
        NexusEvent event = ConversationAssigned;
        event.assigneeId = assigneeId;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getConversationClosedEvent(String conversationId, String adminId) {
        NexusEvent event = ConversationClosed;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public static NexusEvent getConversationReopenedEvent(String conversationId, String adminId) {
        NexusEvent event = ConversationReopened;
        event.adminId = adminId;
        event.conversationId = conversationId;
        return event;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getGuid() {
        return this.guid == null ? UUID.randomUUID().toString() : this.guid;
    }

    public String getAssigneeId() {
        return this.assigneeId;
    }

    public String getAdminAvatarUrl() {
        return this.adminAvatarUrl;
    }
}

