/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.content.Context;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.MainThreadBus;
import io.intercom.android.sdk.api.PollingManager;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;

public class Bridge {
    private static Bridge instance;
    private final PollingManager poller;
    private final MainThreadBus bus;
    private final Api api;
    private final IdentityStore identityStore;
    private final MetricsStore metricsStore;
    private final Context appContext;
    private final NexusWrapper nexusClient;

    private Bridge(Context appContext) {
        this.appContext = appContext.getApplicationContext();
        this.poller = new PollingManager();
        this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        this.identityStore = new IdentityStore(appContext);
        this.metricsStore = new MetricsStore(appContext);
        this.api = new Api(appContext, !this.identityStore.hasIntercomid());
        this.nexusClient = new NexusWrapper();
        this.nexusClient.setLoggingEnabled(false);
    }

    public static synchronized void init(Context context) {
        if (instance == null) {
            Logger.INTERNAL("bridge", "initialising bridge");
            instance = new Bridge(context);
        }
    }

    public static Api getApi() {
        return instance.api();
    }

    public static Bus getBus() {
        return Bridge.instance.bus;
    }

    public static PollingManager getPoller() {
        return Bridge.instance.poller;
    }

    public static IdentityStore getIdentityStore() {
        return Bridge.instance.identityStore;
    }

    public static MetricsStore getMetricsStore() {
        return Bridge.instance.metricsStore;
    }

    public static NexusWrapper getNexusClient() {
        return Bridge.instance.nexusClient;
    }

    public static Context getContext() {
        return Bridge.instance.appContext;
    }

    private Api api() {
        this.api.configureRequestSynchronicity(this.appContext, this.identityStore.hasIntercomid());
        return this.api;
    }
}

