/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.api;

import android.os.Parcel;
import android.os.Parcelable;

public class Avatar
implements Parcelable {
    private final String imageUrl;
    private final String initials;
    private final String color;
    public static final Parcelable.Creator<Avatar> CREATOR = new Parcelable.Creator<Avatar>(){

        public Avatar createFromParcel(Parcel in) {
            return new Avatar(in);
        }

        public Avatar[] newArray(int size) {
            return new Avatar[size];
        }
    };

    public Avatar() {
        this(new Builder());
    }

    private Avatar(Builder builder) {
        this.imageUrl = builder.image_url == null ? "" : builder.image_url;
        this.initials = builder.initials == null ? "" : builder.initials;
        this.color = builder.color == null ? "#ff1d78ae" : builder.color;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getColor() {
        return this.color;
    }

    public String getInitials() {
        return this.initials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Avatar avatar = (Avatar)o;
        if (this.imageUrl != null ? !this.imageUrl.equals(avatar.imageUrl) : avatar.imageUrl != null) {
            return false;
        }
        if (this.initials != null ? !this.initials.equals(avatar.initials) : avatar.initials != null) {
            return false;
        }
        return !(this.color == null ? avatar.color != null : !this.color.equals(avatar.color));
    }

    public int hashCode() {
        int result = this.imageUrl != null ? this.imageUrl.hashCode() : 0;
        result = 31 * result + (this.initials != null ? this.initials.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.imageUrl);
        dest.writeString(this.initials);
        dest.writeString(this.color);
    }

    private Avatar(Parcel in) {
        this.imageUrl = in.readString();
        this.initials = in.readString();
        this.color = in.readString();
    }

    public static final class Builder {
        private String image_url;
        private String initials;
        private String color;

        public Builder withImageUrl(String imageUrl) {
            this.image_url = imageUrl;
            return this;
        }

        public Builder withInitials(String initials) {
            this.initials = initials;
            return this;
        }

        public Builder withColor(String color2) {
            this.color = color2;
            return this;
        }

        public Avatar build() {
            return new Avatar(this);
        }
    }
}

