/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit;

import io.intercom.retrofit.Callback;
import io.intercom.retrofit.Platform;
import io.intercom.retrofit.Types;
import io.intercom.retrofit.client.Header;
import io.intercom.retrofit.client.Response;
import io.intercom.retrofit.http.Body;
import io.intercom.retrofit.http.EncodedPath;
import io.intercom.retrofit.http.EncodedQuery;
import io.intercom.retrofit.http.EncodedQueryMap;
import io.intercom.retrofit.http.Field;
import io.intercom.retrofit.http.FieldMap;
import io.intercom.retrofit.http.FormUrlEncoded;
import io.intercom.retrofit.http.Headers;
import io.intercom.retrofit.http.Multipart;
import io.intercom.retrofit.http.Part;
import io.intercom.retrofit.http.PartMap;
import io.intercom.retrofit.http.Path;
import io.intercom.retrofit.http.Query;
import io.intercom.retrofit.http.QueryMap;
import io.intercom.retrofit.http.RestMethod;
import io.intercom.retrofit.http.Streaming;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rx.Observable;

final class RestMethodInfo {
    private static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    private static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
    final Method method;
    boolean loaded = false;
    final ResponseType responseType;
    final boolean isSynchronous;
    final boolean isObservable;
    Type responseObjectType;
    RequestType requestType = RequestType.SIMPLE;
    String requestMethod;
    boolean requestHasBody;
    String requestUrl;
    Set<String> requestUrlParamNames;
    String requestQuery;
    List<Header> headers;
    String contentTypeHeader;
    boolean isStreaming;
    Annotation[] requestParamAnnotations;

    RestMethodInfo(Method method) {
        this.method = method;
        this.responseType = this.parseResponseType();
        this.isSynchronous = this.responseType == ResponseType.OBJECT;
        this.isObservable = this.responseType == ResponseType.OBSERVABLE;
    }

    private RuntimeException methodError(String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        return new IllegalArgumentException(this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName() + ": " + message);
    }

    private RuntimeException parameterError(int index, String message, Object ... args) {
        return this.methodError(message + " (parameter #" + (index + 1) + ")", args);
    }

    synchronized void init() {
        if (this.loaded) {
            return;
        }
        this.parseMethodAnnotations();
        this.parseParameters();
        this.loaded = true;
    }

    private void parseMethodAnnotations() {
        for (Annotation methodAnnotation : this.method.getAnnotations()) {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            RestMethod methodInfo = null;
            for (Annotation innerAnnotation : annotationType.getAnnotations()) {
                if (RestMethod.class != innerAnnotation.annotationType()) continue;
                methodInfo = (RestMethod)innerAnnotation;
                break;
            }
            if (methodInfo != null) {
                String path;
                if (this.requestMethod != null) {
                    throw this.methodError("Only one HTTP method is allowed. Found: %s and %s.", this.requestMethod, methodInfo.value());
                }
                try {
                    path = (String)annotationType.getMethod("value", new Class[0]).invoke((Object)methodAnnotation, new Object[0]);
                }
                catch (Exception e) {
                    throw this.methodError("Failed to extract String 'value' from @%s annotation.", annotationType.getSimpleName());
                }
                this.parsePath(path);
                this.requestMethod = methodInfo.value();
                this.requestHasBody = methodInfo.hasBody();
                continue;
            }
            if (annotationType == Headers.class) {
                String[] headersToParse = ((Headers)methodAnnotation).value();
                if (headersToParse.length == 0) {
                    throw this.methodError("@Headers annotation is empty.", new Object[0]);
                }
                this.headers = this.parseHeaders(headersToParse);
                continue;
            }
            if (annotationType == Multipart.class) {
                if (this.requestType != RequestType.SIMPLE) {
                    throw this.methodError("Only one encoding annotation is allowed.", new Object[0]);
                }
                this.requestType = RequestType.MULTIPART;
                continue;
            }
            if (annotationType == FormUrlEncoded.class) {
                if (this.requestType != RequestType.SIMPLE) {
                    throw this.methodError("Only one encoding annotation is allowed.", new Object[0]);
                }
                this.requestType = RequestType.FORM_URL_ENCODED;
                continue;
            }
            if (annotationType != Streaming.class) continue;
            if (this.responseObjectType != Response.class) {
                throw this.methodError("Only methods having %s as data type are allowed to have @%s annotation.", Response.class.getSimpleName(), Streaming.class.getSimpleName());
            }
            this.isStreaming = true;
        }
        if (this.requestMethod == null) {
            throw this.methodError("HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
        }
        if (!this.requestHasBody) {
            if (this.requestType == RequestType.MULTIPART) {
                throw this.methodError("Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
            if (this.requestType == RequestType.FORM_URL_ENCODED) {
                throw this.methodError("FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
        }
    }

    private void parsePath(String path) {
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            throw this.methodError("URL path \"%s\" must start with '/'.", path);
        }
        String url = path;
        String query = null;
        int question = path.indexOf(63);
        if (question != -1 && question < path.length() - 1) {
            url = path.substring(0, question);
            query = path.substring(question + 1);
            Matcher queryParamMatcher = PARAM_URL_REGEX.matcher(query);
            if (queryParamMatcher.find()) {
                throw this.methodError("URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", query);
            }
        }
        Set<String> urlParams = RestMethodInfo.parsePathParameters(path);
        this.requestUrl = url;
        this.requestUrlParamNames = urlParams;
        this.requestQuery = query;
    }

    List<Header> parseHeaders(String[] headers) {
        ArrayList<Header> headerList = new ArrayList<Header>();
        for (String header : headers) {
            int colon = header.indexOf(58);
            if (colon == -1 || colon == 0 || colon == header.length() - 1) {
                throw this.methodError("@Headers value must be in the form \"Name: Value\". Found: \"%s\"", header);
            }
            String headerName = header.substring(0, colon);
            String headerValue = header.substring(colon + 1).trim();
            if ("Content-Type".equalsIgnoreCase(headerName)) {
                this.contentTypeHeader = headerValue;
                continue;
            }
            headerList.add(new Header(headerName, headerValue));
        }
        return headerList;
    }

    private ResponseType parseResponseType() {
        boolean hasCallback;
        Type returnType = this.method.getGenericReturnType();
        Type lastArgType = null;
        Class lastArgClass = null;
        Type[] parameterTypes = this.method.getGenericParameterTypes();
        if (parameterTypes.length > 0) {
            Type typeToCheck;
            lastArgType = typeToCheck = parameterTypes[parameterTypes.length - 1];
            if (typeToCheck instanceof ParameterizedType) {
                typeToCheck = ((ParameterizedType)typeToCheck).getRawType();
            }
            if (typeToCheck instanceof Class) {
                lastArgClass = (Class)typeToCheck;
            }
        }
        boolean hasReturnType = returnType != Void.TYPE;
        boolean bl = hasCallback = lastArgClass != null && Callback.class.isAssignableFrom(lastArgClass);
        if (hasReturnType && hasCallback) {
            throw this.methodError("Must have return type or Callback as last argument, not both.", new Object[0]);
        }
        if (!hasReturnType && !hasCallback) {
            throw this.methodError("Must have either a return type or Callback as last argument.", new Object[0]);
        }
        if (hasReturnType) {
            Class<?> rawReturnType;
            if (Platform.HAS_RX_JAVA && RxSupport.isObservable(rawReturnType = Types.getRawType(returnType))) {
                returnType = RxSupport.getObservableType(returnType, rawReturnType);
                this.responseObjectType = RestMethodInfo.getParameterUpperBound((ParameterizedType)returnType);
                return ResponseType.OBSERVABLE;
            }
            this.responseObjectType = returnType;
            return ResponseType.OBJECT;
        }
        if ((lastArgType = Types.getSupertype(lastArgType, Types.getRawType(lastArgType), Callback.class)) instanceof ParameterizedType) {
            this.responseObjectType = RestMethodInfo.getParameterUpperBound((ParameterizedType)lastArgType);
            return ResponseType.VOID;
        }
        throw this.methodError("Last parameter must be of type Callback<X> or Callback<? super X>.", new Object[0]);
    }

    private static Type getParameterUpperBound(ParameterizedType type) {
        Type[] types = type.getActualTypeArguments();
        for (int i = 0; i < types.length; ++i) {
            Type paramType = types[i];
            if (!(paramType instanceof WildcardType)) continue;
            types[i] = ((WildcardType)paramType).getUpperBounds()[0];
        }
        return types[0];
    }

    private void parseParameters() {
        Class<?>[] methodParameterTypes = this.method.getParameterTypes();
        Annotation[][] methodParameterAnnotationArrays = this.method.getParameterAnnotations();
        int count = methodParameterAnnotationArrays.length;
        if (!this.isSynchronous && !this.isObservable) {
            --count;
        }
        Annotation[] requestParamAnnotations = new Annotation[count];
        boolean gotField = false;
        boolean gotPart = false;
        boolean gotBody = false;
        for (int i = 0; i < count; ++i) {
            Class<?> methodParameterType = methodParameterTypes[i];
            Annotation[] methodParameterAnnotations = methodParameterAnnotationArrays[i];
            if (methodParameterAnnotations != null) {
                for (Annotation methodParameterAnnotation : methodParameterAnnotations) {
                    String name;
                    Class<? extends Annotation> methodAnnotationType = methodParameterAnnotation.annotationType();
                    if (methodAnnotationType == Path.class) {
                        name = ((Path)methodParameterAnnotation).value();
                        this.validatePathName(i, name);
                    } else if (methodAnnotationType == EncodedPath.class) {
                        name = ((EncodedPath)methodParameterAnnotation).value();
                        this.validatePathName(i, name);
                    } else if (methodAnnotationType != Query.class && methodAnnotationType != EncodedQuery.class) {
                        if (methodAnnotationType == QueryMap.class) {
                            if (!Map.class.isAssignableFrom(methodParameterType)) {
                                throw this.parameterError(i, "@QueryMap parameter type must be Map.", new Object[0]);
                            }
                        } else if (methodAnnotationType == EncodedQueryMap.class) {
                            if (!Map.class.isAssignableFrom(methodParameterType)) {
                                throw this.parameterError(i, "@EncodedQueryMap parameter type must be Map.", new Object[0]);
                            }
                        } else if (methodAnnotationType != io.intercom.retrofit.http.Header.class) {
                            if (methodAnnotationType == Field.class) {
                                if (this.requestType != RequestType.FORM_URL_ENCODED) {
                                    throw this.parameterError(i, "@Field parameters can only be used with form encoding.", new Object[0]);
                                }
                                gotField = true;
                            } else if (methodAnnotationType == FieldMap.class) {
                                if (this.requestType != RequestType.FORM_URL_ENCODED) {
                                    throw this.parameterError(i, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
                                }
                                if (!Map.class.isAssignableFrom(methodParameterType)) {
                                    throw this.parameterError(i, "@FieldMap parameter type must be Map.", new Object[0]);
                                }
                                gotField = true;
                            } else if (methodAnnotationType == Part.class) {
                                if (this.requestType != RequestType.MULTIPART) {
                                    throw this.parameterError(i, "@Part parameters can only be used with multipart encoding.", new Object[0]);
                                }
                                gotPart = true;
                            } else if (methodAnnotationType == PartMap.class) {
                                if (this.requestType != RequestType.MULTIPART) {
                                    throw this.parameterError(i, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
                                }
                                if (!Map.class.isAssignableFrom(methodParameterType)) {
                                    throw this.parameterError(i, "@PartMap parameter type must be Map.", new Object[0]);
                                }
                                gotPart = true;
                            } else {
                                if (methodAnnotationType != Body.class) continue;
                                if (this.requestType != RequestType.SIMPLE) {
                                    throw this.parameterError(i, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
                                }
                                if (gotBody) {
                                    throw this.methodError("Multiple @Body method annotations found.", new Object[0]);
                                }
                                gotBody = true;
                            }
                        }
                    }
                    if (requestParamAnnotations[i] != null) {
                        throw this.parameterError(i, "Multiple Retrofit annotations found, only one allowed: @%s, @%s.", requestParamAnnotations[i].annotationType().getSimpleName(), methodAnnotationType.getSimpleName());
                    }
                    requestParamAnnotations[i] = methodParameterAnnotation;
                }
            }
            if (requestParamAnnotations[i] != null) continue;
            throw this.parameterError(i, "No Retrofit annotation found.", new Object[0]);
        }
        if (this.requestType == RequestType.SIMPLE && !this.requestHasBody && gotBody) {
            throw this.methodError("Non-body HTTP method cannot contain @Body or @TypedOutput.", new Object[0]);
        }
        if (this.requestType == RequestType.FORM_URL_ENCODED && !gotField) {
            throw this.methodError("Form-encoded method must contain at least one @Field.", new Object[0]);
        }
        if (this.requestType == RequestType.MULTIPART && !gotPart) {
            throw this.methodError("Multipart method must contain at least one @Part.", new Object[0]);
        }
        this.requestParamAnnotations = requestParamAnnotations;
    }

    private void validatePathName(int index, String name) {
        if (!PARAM_NAME_REGEX.matcher(name).matches()) {
            throw this.parameterError(index, "@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), name);
        }
        if (!this.requestUrlParamNames.contains(name)) {
            throw this.parameterError(index, "URL \"%s\" does not contain \"{%s}\".", this.requestUrl, name);
        }
    }

    static Set<String> parsePathParameters(String path) {
        Matcher m = PARAM_URL_REGEX.matcher(path);
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        while (m.find()) {
            patterns.add(m.group(1));
        }
        return patterns;
    }

    private static final class RxSupport {
        private RxSupport() {
        }

        public static boolean isObservable(Class rawType) {
            return rawType == Observable.class;
        }

        public static Type getObservableType(Type contextType, Class contextRawType) {
            return Types.getSupertype(contextType, contextRawType, Observable.class);
        }
    }

    static enum RequestType {
        SIMPLE,
        MULTIPART,
        FORM_URL_ENCODED;

    }

    private static enum ResponseType {
        VOID,
        OBSERVABLE,
        OBJECT;

    }
}

