/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lifecycles;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Gcm;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=15)
public class Lifecycles
implements Application.ActivityLifecycleCallbacks {
    private static final int SESSION_TIMEOUT = 20000;
    private static boolean backgrounded = true;
    private final Set<String> attachedActivities = new HashSet<String>();
    private final DeDuper deDuper;
    private final Api api;
    private long enteredBackgroundAt = 0L;

    public Lifecycles(Api api, DeDuper deDuper) {
        this.deDuper = deDuper;
        this.api = api;
    }

    public static boolean isAppBackgrounded() {
        return backgrounded;
    }

    private static boolean isScreenLocked() {
        KeyguardManager keyguardManager = (KeyguardManager)Bridge.getContext().getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void attachActivity(Activity activity) {
        this.attachedActivities.add(activity.getClass().getName());
    }

    private void detachActivity(Activity activity) {
        this.attachedActivities.remove(activity.getClass().getName());
    }

    private boolean isApplicationInBackground(Activity activity) {
        if (Lifecycles.isScreenLocked()) {
            return true;
        }
        boolean configurationChanged = activity.isChangingConfigurations();
        return this.attachedActivities.isEmpty() && !configurationChanged;
    }

    private void appEnteredBackground(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "backgrounded");
        Bridge.getNexusClient().disconnect();
        this.enteredBackgroundAt = System.currentTimeMillis();
        this.deDuper.reset();
    }

    private void appEnteredForeground(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "foregrounded");
        if (System.currentTimeMillis() - this.enteredBackgroundAt > 20000L) {
            this.api.ping();
            IntercomLogger.INTERNAL("sdk ping", "backgrounded ping from lifecycles");
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        IntercomLogger.INTERNAL("lifecycles", "on create");
        Bridge.init(activity.getApplication());
    }

    public void onActivityStarted(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "on start");
        Bridge.init(activity.getApplication());
        this.attachActivity(activity);
        if (backgrounded) {
            backgrounded = false;
            this.appEnteredForeground(activity);
        }
        Bridge.getNexusClient().connect(Bridge.getIdentityStore().getAppConfig().getRealTimeConfig(), true);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "on resume");
        Bridge.init(activity.getApplication());
        this.attachActivity(activity);
        Gcm.clearNotifications((Context)activity);
    }

    public void onActivityPaused(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "on pause");
        this.detachActivity(activity);
    }

    public void onActivityStopped(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "on stop");
        if (this.isApplicationInBackground(activity)) {
            backgrounded = true;
            this.appEnteredBackground(activity);
        } else {
            this.detachActivity(activity);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        IntercomLogger.INTERNAL("lifecycles", "on destroy");
    }
}

