/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.conversation.lightbox.LightboxActivity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.com.squareup.picasso.Callback;
import io.intercom.com.squareup.picasso.Picasso;
import io.intercom.com.squareup.picasso.RequestCreator;
import io.intercom.com.squareup.picasso.Transformation;

public class NetworkImage
extends Image
implements ImageBlock {
    public NetworkImage(Context context, StyleType style) {
        super(context);
    }

    public View addImage(final String url, final String linkUrl, final int width, final int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        FrameLayout rootView = (FrameLayout)this.inflater.inflate(R.layout.intercomsdk_blocks_image, parent, false);
        final ImageView imageView = (ImageView)rootView.findViewById(R.id.image_block);
        this.setBackgroundColor(imageView);
        final ProgressBar spinner = (ProgressBar)rootView.findViewById(R.id.loading_wheel);
        if (spinner != null) {
            spinner.getIndeterminateDrawable().setColorFilter(this.context.getResources().getColor(R.color.intercomsdk_image_loading_grey), PorterDuff.Mode.SRC_IN);
        }
        RequestCreator requestCreator = Picasso.with((Context)this.context).load(url);
        if (isFirstObject && isLastObject) {
            requestCreator.transform((Transformation)new RoundedCornersTransform(this.context.getResources().getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners)));
        }
        this.setImageViewBounds(width, height, imageView, requestCreator);
        requestCreator.into(imageView, new Callback(){

            public void onSuccess() {
                IntercomLogger.INTERNAL("images", "SUCCESS");
                if (spinner != null) {
                    spinner.setVisibility(8);
                    imageView.setBackgroundResource(17170445);
                }
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (linkUrl.isEmpty()) {
                                Intent i = new Intent(NetworkImage.this.context, LightboxActivity.class);
                                i.putExtra("image_url", url);
                                i.putExtra("image_width", width);
                                i.putExtra("image_height", height);
                                i.setFlags(0x10000000);
                                NetworkImage.this.context.startActivity(i);
                            } else {
                                Uri uri = Uri.parse((String)linkUrl);
                                Intent intent = new Intent("android.intent.action.VIEW", uri);
                                intent.setFlags(0x10000000);
                                NetworkImage.this.context.startActivity(intent);
                            }
                        }
                    });
                }
            }

            public void onError() {
                IntercomLogger.INTERNAL("images", "FAILURE");
            }
        });
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }
}

