/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

public class Heading
implements HeadingBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public Heading(Context context, StyleType style) {
        this.style = style;
        this.context = context;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addHeading(String text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case ADMIN: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_heading, parent, false);
                break;
            }
            case ANNOUNCEMENT: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_announcement_heading, parent, false);
                int color2 = Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor());
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                FontUtils.setTypeface(textview, "intercomsdk_roboto_light.ttf", this.context);
                break;
            }
            case WELCOME: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_heading, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_heading, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)Html.fromHtml((String)text));
        textview.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textview, alignment.getGravity(), isLastObject);
        return textview;
    }
}

