/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.ext.StringExtKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u001b\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0013J\u001a\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J)\u0010\u0018\u001a\u00020\t\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u0002H\rH\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/koin/core/registry/PropertyRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_values", "", "", "close", "", "deleteProperty", "key", "getProperty", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "loadEnvironmentProperties", "loadPropertiesFromFile", "fileName", "readDataFromFile", "Ljava/util/Properties;", "content", "saveProperties", "properties", "", "saveProperty", "value", "saveProperty$koin_core", "(Ljava/lang/String;Ljava/lang/Object;)V", "koin-core"})
public final class PropertyRegistry {
    @NotNull
    private final Koin _koin;
    @NotNull
    private final Map<String, Object> _values;

    public PropertyRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._values = new ConcurrentHashMap();
    }

    public final void saveProperties(@NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        if (this._koin.getLogger().isAt(Level.DEBUG)) {
            this._koin.getLogger().debug("load " + properties.size() + " properties");
        }
        this._values.putAll(properties);
    }

    public final void saveProperties(@NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if (this._koin.getLogger().isAt(Level.DEBUG)) {
            this._koin.getLogger().debug("load " + properties.size() + " properties");
        }
        Map $this$forEach$iv = propertiesMapValues = MapsKt.toMap((Map)properties);
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$k$v;
            boolean bl3 = false;
            String k = (String)entry.getKey();
            Map.Entry entry2 = $dstr$k$v;
            boolean bl4 = false;
            String v = (String)entry2.getValue();
            this.saveProperty$koin_core(k, StringExtKt.quoted(v));
        }
    }

    public final <T> void saveProperty$koin_core(@NotNull String key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map<String, Object> map = this._values;
        boolean bl = false;
        map.put(key, value);
    }

    public final void deleteProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this._values.remove(key);
    }

    @Nullable
    public final <T> T getProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this._values.get(key);
        if (object == null) {
            // empty if block
        }
        return (T)object;
    }

    public final void loadPropertiesFromFile(@NotNull String fileName) {
        String content;
        String string;
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (this._koin.getLogger().isAt(Level.DEBUG)) {
            this._koin.getLogger().debug(Intrinsics.stringPlus((String)"load properties from ", (Object)fileName));
        }
        if ((uRL = Koin.class.getResource(fileName)) == null) {
            string = null;
        } else {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            string = content = new String(byArray, charset);
        }
        if (content != null) {
            if (this._koin.getLogger().isAt(Level.INFO)) {
                this._koin.getLogger().info("loaded properties from file:'" + fileName + '\'');
            }
        } else {
            throw new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        Properties properties = this.readDataFromFile(content);
        this.saveProperties(properties);
    }

    private final Properties readDataFromFile(String content) {
        Properties properties = new Properties();
        String string = content;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    public final void loadEnvironmentProperties() {
        if (this._koin.getLogger().isAt(Level.DEBUG)) {
            this._koin.getLogger().debug("load properties from environment");
        }
        Properties sysProperties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)sysProperties, (String)"sysProperties");
        this.saveProperties(sysProperties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        boolean bl = false;
        Properties properties = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties2 = properties;
        boolean bl4 = false;
        properties2.putAll(map);
        Properties sysEnvProperties = properties;
        this.saveProperties(sysEnvProperties);
    }

    public final void close() {
        this._values.clear();
    }
}

