/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.definition.BeanDefinitionKt;
import org.koin.core.instance.FactoryInstanceFactory;
import org.koin.core.instance.InstanceContext;
import org.koin.core.instance.InstanceFactory;
import org.koin.core.instance.SingleInstanceFactory;
import org.koin.core.logger.Level;
import org.koin.core.parameter.DefinitionParameters;
import org.koin.core.registry.InstanceRegistry$WhenMappings;
import org.koin.core.scope.Scope;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JE\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00182\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bj\u0004\u0018\u0001`\u001dH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u001f\u0010#\u001a\u00020!2\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%H\u0000\u00a2\u0006\u0002\b'J\u0019\u0010(\u001a\u00020!2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030&H\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020!H\u0000\u00a2\u0006\u0002\b,J \u0010-\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010)\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u001e\u0010.\u001a\u00020/2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bj\u0004\u0018\u0001`\u001dH\u0002J\u0019\u00100\u001a\u00020!2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030&H\u0000\u00a2\u0006\u0002\b1J)\u00102\u001a\b\u0012\u0004\u0012\u0002H403\"\b\b\u0000\u00104*\u00020\u00012\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0000\u00a2\u0006\u0002\b6J9\u00107\u001a\u0004\u0018\u0001H4\"\u0004\b\u0000\u001042\n\u00108\u001a\u00060\tj\u0002`\n2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bj\u0004\u0018\u0001`\u001dH\u0000\u00a2\u0006\u0004\b9\u0010:J\u001a\u0010;\u001a\u00020!2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010<\u001a\u00020=J(\u0010>\u001a\u00020!2\n\u0010?\u001a\u00060\tj\u0002`\n2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010<\u001a\u00020=H\u0002J \u0010A\u001a\u00020!2\n\u0010?\u001a\u00060\tj\u0002`\n2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R:\u0010\u0007\u001a.\u0012\b\u0012\u00060\tj\u0002`\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\bj\u0016\u0012\b\u0012\u00060\tj\u0002`\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R%\u0010\u0011\u001a\u0016\u0012\b\u0012\u00060\tj\u0002`\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006B"}, d2={"Lorg/koin/core/registry/InstanceRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "_scope", "Lorg/koin/core/scope/Scope;", "(Lorg/koin/core/Koin;Lorg/koin/core/scope/Scope;)V", "_instances", "Ljava/util/HashMap;", "", "Lorg/koin/core/definition/IndexKey;", "Lorg/koin/core/instance/InstanceFactory;", "Lkotlin/collections/HashMap;", "get_koin", "()Lorg/koin/core/Koin;", "get_scope", "()Lorg/koin/core/scope/Scope;", "instances", "", "getInstances", "()Ljava/util/Map;", "bind", "S", "primaryType", "Lkotlin/reflect/KClass;", "secondaryType", "parameters", "Lkotlin/Function0;", "Lorg/koin/core/parameter/DefinitionParameters;", "Lorg/koin/core/parameter/ParametersDefinition;", "bind$koin_core", "(Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "close", "", "close$koin_core", "create", "definitions", "", "Lorg/koin/core/definition/BeanDefinition;", "create$koin_core", "createDefinition", "definition", "createDefinition$koin_core", "createEagerInstances", "createEagerInstances$koin_core", "createInstanceFactory", "defaultInstanceContext", "Lorg/koin/core/instance/InstanceContext;", "dropDefinition", "dropDefinition$koin_core", "getAll", "", "T", "clazz", "getAll$koin_core", "resolveInstance", "indexKey", "resolveInstance$koin_core", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "saveDefinition", "override", "", "saveInstance", "key", "factory", "saveInstanceIfPossible", "koin-core"})
public final class InstanceRegistry {
    private final HashMap<String, InstanceFactory<?>> _instances;
    @NotNull
    private final Koin _koin;
    @NotNull
    private final Scope _scope;

    @NotNull
    public final Map<String, InstanceFactory<?>> getInstances() {
        return this._instances;
    }

    public final void create$koin_core(@NotNull Set<? extends BeanDefinition<?>> definitions) {
        Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
        Iterable $this$forEach$iv = definitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BeanDefinition definition = (BeanDefinition)element$iv;
            boolean bl = false;
            if (this._koin.getLogger().isAt(Level.DEBUG)) {
                if (this._scope.get_scopeDefinition().isRoot()) {
                    this._koin.getLogger().debug("- " + definition);
                } else {
                    this._koin.getLogger().debug(this._scope + " -> " + definition);
                }
            }
            this.saveDefinition(definition, false);
        }
    }

    public final void saveDefinition(@NotNull BeanDefinition<?> definition, boolean override) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        boolean defOverride = definition.getOptions().getOverride() || override;
        InstanceFactory<?> instanceFactory = this.createInstanceFactory(this._koin, definition);
        this.saveInstance(BeanDefinitionKt.indexKey(definition.getPrimaryType(), definition.getQualifier()), instanceFactory, defOverride);
        Iterable $this$forEach$iv = definition.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass clazz = (KClass)element$iv;
            boolean bl = false;
            if (defOverride) {
                this.saveInstance(BeanDefinitionKt.indexKey(clazz, definition.getQualifier()), instanceFactory, defOverride);
                continue;
            }
            this.saveInstanceIfPossible(BeanDefinitionKt.indexKey(clazz, definition.getQualifier()), instanceFactory);
        }
    }

    private final InstanceFactory<?> createInstanceFactory(Koin _koin, BeanDefinition<?> definition) {
        InstanceFactory instanceFactory;
        switch (InstanceRegistry$WhenMappings.$EnumSwitchMapping$0[definition.getKind().ordinal()]) {
            case 1: {
                instanceFactory = new SingleInstanceFactory(_koin, definition);
                break;
            }
            case 2: {
                instanceFactory = new FactoryInstanceFactory(_koin, definition);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return instanceFactory;
    }

    private final void saveInstance(String key, InstanceFactory<?> factory, boolean override) {
        Object object = this._instances;
        boolean bl = false;
        Map map = object;
        boolean bl2 = false;
        if (map.containsKey(key) && !override) {
            object = "InstanceRegistry already contains index '" + key + '\'';
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        ((Map)this._instances).put(key, factory);
    }

    private final void saveInstanceIfPossible(String key, InstanceFactory<?> factory) {
        Map map = this._instances;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(key)) {
            ((Map)this._instances).put(key, factory);
        }
    }

    @Nullable
    public final <T> T resolveInstance$koin_core(@NotNull String indexKey, @Nullable Function0<? extends DefinitionParameters> parameters) {
        Intrinsics.checkNotNullParameter((Object)indexKey, (String)"indexKey");
        InstanceFactory<?> instanceFactory = this._instances.get(indexKey);
        Object v1 = instanceFactory != null ? instanceFactory.get(this.defaultInstanceContext(parameters)) : null;
        if (!(v1 instanceof Object)) {
            v1 = null;
        }
        return v1;
    }

    private final InstanceContext defaultInstanceContext(Function0<? extends DefinitionParameters> parameters) {
        return new InstanceContext(this._koin, this._scope, parameters);
    }

    public final void close$koin_core() {
        Collection<InstanceFactory<?>> collection = this._instances.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"_instances.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstanceFactory it = (InstanceFactory)element$iv;
            boolean bl = false;
            it.drop();
        }
        this._instances.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void createEagerInstances$koin_core() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getInstances().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SingleInstanceFactory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SingleInstanceFactory instance = (SingleInstanceFactory)element$iv$iv;
            boolean bl = false;
            if (!instance.getBeanDefinition().getOptions().isCreatedAtStart()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleInstanceFactory instance = (SingleInstanceFactory)element$iv;
            boolean bl = false;
            instance.get(new InstanceContext(this._koin, this._scope, null, 4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> getAll$koin_core(@NotNull KClass<?> clazz) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Set instances = CollectionsKt.toSet((Iterable)this.getInstances().values());
        Iterable $this$filter$iv = instances;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InstanceFactory instance = (InstanceFactory)element$iv$iv;
            boolean bl = false;
            if (!instance.getBeanDefinition().hasType(clazz)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List potentialKeys = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = potentialKeys;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            InstanceFactory it = (InstanceFactory)element$iv$iv;
            boolean bl2 = false;
            Object t = it.get(this.defaultInstanceContext(null));
            if (!(t instanceof Object)) {
                t = null;
            }
            if (t == null) continue;
            Object t2 = t;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it$iv$iv = t2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <S> S bind$koin_core(@NotNull KClass<?> primaryType, @NotNull KClass<?> secondaryType, @Nullable Function0<? extends DefinitionParameters> parameters) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(primaryType, (String)"primaryType");
            Intrinsics.checkNotNullParameter(secondaryType, (String)"secondaryType");
            Iterable $this$firstOrNull$iv = this.getInstances().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                InstanceFactory instance = (InstanceFactory)element$iv;
                boolean bl = false;
                if (!instance.getBeanDefinition().canBind(primaryType, secondaryType)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        InstanceFactory instanceFactory = v0;
        Object v2 = instanceFactory != null ? instanceFactory.get(this.defaultInstanceContext(parameters)) : null;
        if (!(v2 instanceof Object)) {
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    public final void dropDefinition$koin_core(@NotNull BeanDefinition<?> definition) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Map $this$filter$iv = this._instances;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!Intrinsics.areEqual(((InstanceFactory)it.getValue()).getBeanDefinition(), definition)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var8_8 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : var8_8.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            String string = (String)it.getKey();
            object.add(string);
        }
        List ids = (List)destination$iv$iv;
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl4 = false;
            this._instances.remove(it2);
        }
    }

    public final void createDefinition$koin_core(@NotNull BeanDefinition<?> definition) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        this.saveDefinition(definition, definition.getOptions().getOverride());
    }

    @NotNull
    public final Koin get_koin() {
        return this._koin;
    }

    @NotNull
    public final Scope get_scope() {
        return this._scope;
    }

    public InstanceRegistry(@NotNull Koin _koin, @NotNull Scope _scope) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        Intrinsics.checkNotNullParameter((Object)_scope, (String)"_scope");
        this._koin = _koin;
        this._scope = _scope;
        this._instances = new HashMap();
    }
}

