/*
 * Decompiled with CFR 0.152.
 */
package org.koin.androidx.scope;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.androidx.scope.LifecycleScopeDelegateKt;
import org.koin.core.Koin;
import org.koin.core.component.KoinScopeComponentKt;
import org.koin.core.context.GlobalContext;
import org.koin.core.context.KoinContext;
import org.koin.core.logger.Logger;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B-\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00032\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0096\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/koin/androidx/scope/LifecycleScopeDelegate;", "T", "Lkotlin/properties/ReadOnlyProperty;", "Landroidx/lifecycle/LifecycleOwner;", "Lorg/koin/core/scope/Scope;", "lifecycleOwner", "koinContext", "Lorg/koin/core/context/KoinContext;", "createScope", "Lkotlin/Function1;", "Lorg/koin/core/Koin;", "(Landroidx/lifecycle/LifecycleOwner;Lorg/koin/core/context/KoinContext;Lkotlin/jvm/functions/Function1;)V", "_scope", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "koin-android_release"})
public final class LifecycleScopeDelegate<T>
implements ReadOnlyProperty<LifecycleOwner, Scope> {
    @NotNull
    private final LifecycleOwner lifecycleOwner;
    @NotNull
    private final KoinContext koinContext;
    @NotNull
    private final Function1<Koin, Scope> createScope;
    @Nullable
    private Scope _scope;

    public LifecycleScopeDelegate(@NotNull LifecycleOwner lifecycleOwner, @NotNull KoinContext koinContext, @NotNull Function1<? super Koin, Scope> createScope) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)koinContext, (String)"koinContext");
        Intrinsics.checkNotNullParameter(createScope, (String)"createScope");
        this.lifecycleOwner = lifecycleOwner;
        this.koinContext = koinContext;
        this.createScope = createScope;
        Koin koin = this.koinContext.get();
        final Logger logger = koin.getLogger();
        logger.debug("setup scope: " + this._scope + " for " + this.lifecycleOwner);
        String scopeId = KoinScopeComponentKt.getScopeId((Object)this.lifecycleOwner);
        Scope scope = koin.getScopeOrNull(scopeId);
        this._scope = scope == null ? (Scope)this.createScope.invoke((Object)koin) : scope;
        logger.debug("got scope: " + this._scope + " for " + this.lifecycleOwner);
        this.lifecycleOwner.getLifecycle().addObserver(new LifecycleObserver(){

            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public final void onDestroy(@NotNull LifecycleOwner owner2) {
                Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
                logger.debug("Closing scope: " + _scope + " for " + this.getLifecycleOwner());
                Scope scope = _scope;
                if ((scope == null ? false : !scope.getClosed()) && (scope = _scope) != null) {
                    scope.close();
                }
                _scope = null;
            }
        });
    }

    public /* synthetic */ LifecycleScopeDelegate(final LifecycleOwner lifecycleOwner, KoinContext koinContext, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            koinContext = (KoinContext)GlobalContext.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<Koin, Scope>(){

                @NotNull
                public final Scope invoke(@NotNull Koin koin) {
                    Intrinsics.checkNotNullParameter((Object)koin, (String)"koin");
                    return koin.createScope(KoinScopeComponentKt.getScopeId((Object)lifecycleOwner), (Qualifier)KoinScopeComponentKt.getScopeName((Object)lifecycleOwner), (Object)lifecycleOwner);
                }
            };
        }
        this(lifecycleOwner, koinContext, (Function1<? super Koin, Scope>)function1);
    }

    @NotNull
    public final LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    @NotNull
    public Scope getValue(@NotNull LifecycleOwner thisRef, @NotNull KProperty<?> property) {
        Scope scope;
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this._scope != null) {
            Scope scope2 = this._scope;
            scope = scope2;
            Intrinsics.checkNotNull((Object)scope2);
        } else {
            if (!LifecycleScopeDelegateKt.isActive(thisRef)) {
                String string = "can't get Scope for " + this.lifecycleOwner + " - LifecycleOwner is not Active";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Koin koin = this.koinContext.get();
            Scope scope3 = koin.getScopeOrNull(KoinScopeComponentKt.getScopeId((Object)thisRef));
            this._scope = scope3 == null ? (Scope)this.createScope.invoke((Object)koin) : scope3;
            koin.getLogger().debug("got scope: " + this._scope + " for " + this.lifecycleOwner);
            Scope scope4 = this._scope;
            scope = scope4;
            Intrinsics.checkNotNull((Object)scope4);
        }
        return scope;
    }
}

