/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.CgiData;
import io.honeybadger.reporter.dto.Context;
import io.honeybadger.reporter.dto.Params;
import io.honeybadger.reporter.dto.Request;
import io.honeybadger.reporter.dto.Session;
import java.util.Iterator;
import java.util.Optional;
import play.mvc.Http;
import play.mvc.Security;

public final class PlayHttpRequestFactory {
    private PlayHttpRequestFactory() {
    }

    public static Request create(ConfigContext config, Http.Request httpRequest) {
        Context context = PlayHttpRequestFactory.createContext(httpRequest);
        String url = PlayHttpRequestFactory.getFullURL(httpRequest);
        Params params = PlayHttpRequestFactory.createParams(config, httpRequest);
        Session session = PlayHttpRequestFactory.createSession(httpRequest);
        CgiData cgiData = PlayHttpRequestFactory.createCgiData(httpRequest);
        return new Request(context, url, params, session, cgiData);
    }

    protected static Context createContext(Http.Request httpRequest) {
        Context context = new Context();
        Optional username = httpRequest.attrs().getOptional(Security.USERNAME);
        username.ifPresent(context::setUsername);
        return context;
    }

    protected static String getFullURL(Http.Request httpRequest) {
        return httpRequest.uri();
    }

    protected static Params createParams(ConfigContext config, Http.Request httpRequest) {
        Http.RequestBody body = httpRequest.body();
        if (body == null) {
            return new Params(config.getExcludedParams());
        }
        return Params.parseParamsFromMap(config.getExcludedParams(), body.asFormUrlEncoded());
    }

    protected static Session createSession(Http.Request httpRequest) {
        Session session = new Session();
        return session;
    }

    protected static CgiData createCgiData(Http.Request httpRequest) {
        CgiData cgiData = new CgiData().setRequestMethod(httpRequest.method()).setContentLength(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Content-Length")).setHttpAccept(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Accept")).setHttpUserAgent(PlayHttpRequestFactory.getHeaderValue(httpRequest, "User-Agent")).setHttpAcceptCharset(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Accept-Charset")).setHttpAcceptEncoding(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Accept-Encoding")).setHttpAcceptLanguage(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Accept-Language")).setHttpCookie(PlayHttpRequestFactory.parseCookies(httpRequest)).setContentLength(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Content-Length")).setContentType(PlayHttpRequestFactory.getHeaderValue(httpRequest, "Content-Type")).setRemoteAddr(httpRequest.remoteAddress()).setQueryString(httpRequest.queryString()).setPathInfo(httpRequest.path());
        if (httpRequest.host() != null && !httpRequest.host().isEmpty()) {
            String[] hostParts = httpRequest.host().split(":");
            if (hostParts.length > 0) {
                cgiData.setServerName(hostParts[0]);
            }
            if (hostParts.length > 1) {
                cgiData.setServerPort(hostParts[1]);
            }
        }
        return cgiData;
    }

    static Object getHeaderValue(Http.Request httpRequest, String key) {
        Http.Headers headers = httpRequest.getHeaders();
        return headers.get(key).orElse(null);
    }

    static String parseCookies(Http.Request httpRequest) {
        Http.Cookies cookies = httpRequest.cookies();
        Iterator itr = cookies.iterator();
        if (cookies == null || !itr.hasNext()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (itr.hasNext()) {
            Http.Cookie next = (Http.Cookie)itr.next();
            String c = String.format("%s=%s", next.name(), next.value());
            builder.append(c.trim());
            if (!itr.hasNext()) continue;
            builder.append("; ");
        }
        return builder.toString();
    }
}

