/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.CgiData;
import io.honeybadger.reporter.dto.Details;
import io.honeybadger.reporter.dto.NoticeDetails;
import io.honeybadger.reporter.dto.Notifier;
import io.honeybadger.reporter.dto.Request;
import io.honeybadger.reporter.dto.ServerDetails;
import java.io.Serializable;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"environment", "created_at", "message", "token", "fault_id", "application_trace", "backtrace", "deploy", "url"})
public class Notice
implements Serializable {
    private static final long serialVersionUID = 1661111694538362413L;
    private Long id = null;
    private final ConfigContext config;
    private Notifier notifier = new Notifier();
    private ServerDetails server;
    private Details details;
    private Request request;
    private NoticeDetails error;

    public Notice(ConfigContext config) {
        this.config = config;
        this.server = new ServerDetails(config);
        this.details = new Details(this.config);
        this.details.addDefaultDetails();
    }

    @JsonCreator
    public Notice(@JacksonInject(value="config") ConfigContext config, @JsonProperty(value="id") Long id, @JsonProperty(value="web_environment") CgiData webEnvironment, @JsonProperty(value="request") Request request) {
        this.config = config;
        this.id = id;
        this.server = new ServerDetails(config);
        this.request = request;
        this.request.setCgiData(webEnvironment);
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public Notice setNotifier(Notifier notifier) {
        this.notifier = notifier;
        return this;
    }

    public NoticeDetails getError() {
        return this.error;
    }

    public Notice setError(NoticeDetails error) {
        this.error = error;
        return this;
    }

    public Notice setServer(ServerDetails server) {
        this.server = server;
        return this;
    }

    public ServerDetails getServer() {
        return this.server;
    }

    public Details getDetails() {
        return this.details;
    }

    public Notice setDetails(Details details) {
        this.details = details;
        return this;
    }

    public Request getRequest() {
        return this.request;
    }

    public Notice setRequest(Request request) {
        this.request = request;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Notice)) {
            return false;
        }
        Notice notice = (Notice)o;
        return Objects.equals(this.config, notice.config) && Objects.equals(this.notifier, notice.notifier) && Objects.equals(this.server, notice.server) && Objects.equals(this.details, notice.details) && Objects.equals(this.request, notice.request) && Objects.equals(this.error, notice.error);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.notifier, this.server, this.details, this.request, this.error);
    }

    public Long getId() {
        return this.id;
    }
}

