/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.BacktraceElement;
import java.io.Serializable;
import java.util.ArrayList;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Backtrace
extends ArrayList<BacktraceElement>
implements Serializable {
    private static final long serialVersionUID = 5788866962863555294L;
    private final ConfigContext config;

    public Backtrace(ConfigContext config, Throwable error) {
        this.config = config;
        if (error == null) {
            throw new IllegalArgumentException("Error must not be null");
        }
        this.addTrace(error);
    }

    @JsonCreator
    public Backtrace(@JacksonInject(value="config") ConfigContext config) {
        this.config = config;
    }

    void addTrace(Throwable error) {
        for (StackTraceElement trace : error.getStackTrace()) {
            this.add(new BacktraceElement(this.config, trace));
        }
    }
}

