/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.honeybadger.reporter.config.BaseChainedConfigContext;
import io.honeybadger.reporter.config.MapConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import io.honeybadger.util.HBStringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import play.Environment;

public class PlayConfigContext
extends BaseChainedConfigContext {
    public PlayConfigContext(Config configuration, Environment environment) {
        String env = environment == null ? "UNKNOWN" : (environment.mode().name() == null || environment.mode().name().isEmpty() ? "UNKNOWN" : environment.mode().name());
        if (configuration != null) {
            Map<String, Object> unwrapped;
            try (Stream stream = configuration.entrySet().stream();){
                unwrapped = stream.map(ConfigEntry::fromConfigValueEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            Map<String, Object> configMap = PlayConfigContext.flattenNestedMap(unwrapped);
            MapConfigContext mapContext = new MapConfigContext(configMap);
            mapContext.put("ENV", env);
            this.overwriteWithContext(mapContext);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Null Play configuration. Using defaults and system settings.");
            this.overwriteWithContext(new SystemSettingsConfigContext());
        }
    }

    static Map<String, Object> flattenNestedMap(Map<String, Object> map) {
        return PlayConfigContext.flattenNestedMap(map, 0L);
    }

    static Map<String, Object> flattenNestedMap(Map<String, Object> map, long level) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> flat = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key;
            if (entry.getKey() == null || entry.getKey().isEmpty()) continue;
            if (entry.getValue() instanceof Map) {
                Map innerMap = (Map)entry.getValue();
                if (innerMap.isEmpty()) continue;
                Map<String, Object> subFlat = PlayConfigContext.flattenNestedMap(innerMap, level + 1L);
                for (Map.Entry<String, Object> subEntry : subFlat.entrySet()) {
                    String subKey = HBStringUtils.stripTrailingChar(subEntry.getKey(), '.');
                    String key2 = String.format("%s.%s", entry.getKey(), subKey);
                    flat.put(key2, subEntry.getValue());
                }
                continue;
            }
            if (level == 0L) {
                key = HBStringUtils.stripTrailingChar(entry.getKey(), '.');
                flat.put(String.format("%s", key), entry.getValue());
                continue;
            }
            key = HBStringUtils.stripTrailingChar(entry.getKey(), '.');
            flat.put(String.format("%s.", key), entry.getValue());
        }
        return flat;
    }

    private static final class ConfigEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V val;

        static Map.Entry<String, Object> fromConfigValueEntry(Map.Entry<String, ConfigValue> entry) {
            return new ConfigEntry<String, Object>(entry.getKey(), entry.getValue().unwrapped());
        }

        ConfigEntry(K key, V val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.val;
            this.val = value;
            return oldValue;
        }
    }
}

