/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter.optimization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.hetu.core.plugin.datacenter.DataCenterColumn;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterTableHandle;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.hetu.core.plugin.datacenter.optimization.DataCenterQueryGenerator;
import io.prestosql.expressions.LogicalRowExpressions;
import io.prestosql.plugin.jdbc.optimization.JdbcConverterContext;
import io.prestosql.plugin.jdbc.optimization.JdbcPlanOptimizerUtils;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorContext;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorResult;
import io.prestosql.spi.ConnectorPlanOptimizer;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.SymbolAllocator;
import io.prestosql.spi.connector.CatalogName;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.function.FunctionMetadataManager;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.StandardFunctionResolution;
import io.prestosql.spi.metadata.TableHandle;
import io.prestosql.spi.operator.ReuseExchangeOperator;
import io.prestosql.spi.plan.Assignments;
import io.prestosql.spi.plan.FilterNode;
import io.prestosql.spi.plan.GroupIdNode;
import io.prestosql.spi.plan.MarkDistinctNode;
import io.prestosql.spi.plan.PlanNode;
import io.prestosql.spi.plan.PlanNodeIdAllocator;
import io.prestosql.spi.plan.PlanVisitor;
import io.prestosql.spi.plan.ProjectNode;
import io.prestosql.spi.plan.Symbol;
import io.prestosql.spi.plan.TableScanNode;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.DeterminismEvaluator;
import io.prestosql.spi.relation.RowExpression;
import io.prestosql.spi.relation.RowExpressionVisitor;
import io.prestosql.spi.relation.VariableReferenceExpression;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.UnknownType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.inject.Inject;
import okhttp3.OkHttpClient;

public class DataCenterPlanOptimizer
implements ConnectorPlanOptimizer {
    private static final Logger log = Logger.get(DataCenterPlanOptimizer.class);
    private static final String DATACENTER_CATALOG_PREFIX = "dc.";
    private static final Set<Class<? extends PlanNode>> UNSUPPORTED_ROOT_NODE = ImmutableSet.of(GroupIdNode.class, MarkDistinctNode.class);
    private final DataCenterClient client;
    private final DataCenterConfig config;
    private final TypeManager typeManager;
    private final DataCenterQueryGenerator queryGenerator;
    private final StandardFunctionResolution functionResolution;
    private final LogicalRowExpressions logicalRowExpressions;

    @Inject
    public DataCenterPlanOptimizer(TypeManager typeManager, DataCenterConfig config, DataCenterQueryGenerator query, DeterminismEvaluator determinismEvaluator, FunctionMetadataManager functionManager, StandardFunctionResolution functionResolution) {
        OkHttpClient httpClient = DataCenterStatementClientFactory.newHttpClient(config);
        this.client = new DataCenterClient(config, httpClient, typeManager);
        this.config = config;
        this.typeManager = typeManager;
        this.queryGenerator = query;
        this.functionResolution = functionResolution;
        this.logicalRowExpressions = new LogicalRowExpressions(determinismEvaluator, functionResolution, functionManager);
    }

    public PlanNode optimize(PlanNode maxSubPlan, ConnectorSession session, Map<String, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        if (!this.config.isQueryPushDownEnabled()) {
            return maxSubPlan;
        }
        if (UNSUPPORTED_ROOT_NODE.contains(maxSubPlan.getClass())) {
            return maxSubPlan;
        }
        return (PlanNode)maxSubPlan.accept((PlanVisitor)new Visitor(idAllocator, types, session, symbolAllocator), null);
    }

    private static PlanNode replaceChildren(PlanNode node, List<PlanNode> children) {
        for (int i = 0; i < node.getSources().size(); ++i) {
            if (children.get(i) == node.getSources().get(i)) continue;
            return node.replaceChildren(children);
        }
        return node;
    }

    private class Visitor
    extends PlanVisitor<PlanNode, Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final ConnectorSession session;
        private final Map<String, Type> types;
        private final SymbolAllocator symbolAllocator;
        private final IdentityHashMap<FilterNode, Void> filtersSplitUp = new IdentityHashMap();

        public Visitor(PlanNodeIdAllocator idAllocator, Map<String, Type> types, ConnectorSession session, SymbolAllocator symbolAllocator) {
            this.idAllocator = idAllocator;
            this.types = types;
            this.session = session;
            this.symbolAllocator = symbolAllocator;
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            Optional<PlanNode> pushDownPlan = this.tryCreatingNewScanNode(node);
            return pushDownPlan.orElseGet(() -> DataCenterPlanOptimizer.replaceChildren(node, (List)node.getSources().stream().map(source -> (PlanNode)source.accept((PlanVisitor)this, null)).collect(ImmutableList.toImmutableList())));
        }

        public PlanNode visitFilter(FilterNode node, Void context) {
            if (this.filtersSplitUp.containsKey(node)) {
                return this.visitPlan((PlanNode)node, context);
            }
            this.filtersSplitUp.put(node, null);
            FilterNode nodeToRecurseInto = node;
            ArrayList<RowExpression> pushable = new ArrayList<RowExpression>();
            ArrayList<RowExpression> nonPushable = new ArrayList<RowExpression>();
            DataCenterPlanOptimizer.this.logicalRowExpressions;
            for (RowExpression conjunct : LogicalRowExpressions.extractConjuncts((RowExpression)node.getPredicate())) {
                try {
                    conjunct.accept((RowExpressionVisitor)DataCenterPlanOptimizer.this.queryGenerator.getConverter(), (Object)new JdbcConverterContext());
                    pushable.add(conjunct);
                }
                catch (PrestoException pe) {
                    nonPushable.add(conjunct);
                }
            }
            if (!pushable.isEmpty()) {
                FilterNode pushableFilter = new FilterNode(this.idAllocator.getNextId(), node.getSource(), DataCenterPlanOptimizer.this.logicalRowExpressions.combineConjuncts(pushable));
                Optional nonPushableFilter = nonPushable.isEmpty() ? Optional.empty() : Optional.of(new FilterNode(this.idAllocator.getNextId(), (PlanNode)pushableFilter, DataCenterPlanOptimizer.this.logicalRowExpressions.combineConjuncts(nonPushable)));
                this.filtersSplitUp.put(pushableFilter, null);
                if (nonPushableFilter.isPresent()) {
                    FilterNode nonPushableFilterNode = (FilterNode)nonPushableFilter.get();
                    this.filtersSplitUp.put(nonPushableFilterNode, null);
                    nodeToRecurseInto = nonPushableFilterNode;
                } else {
                    nodeToRecurseInto = pushableFilter;
                }
            }
            return this.visitFilter(nodeToRecurseInto, context);
        }

        private Optional<PlanNode> tryCreatingNewScanNode(PlanNode node) {
            List<DataCenterColumn> columnsList;
            Optional result = DataCenterPlanOptimizer.this.queryGenerator.generate(node, DataCenterPlanOptimizer.this.typeManager);
            if (!result.isPresent()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext context = ((JdbcQueryGeneratorResult)result.get()).getContext();
            JdbcQueryGeneratorResult.GeneratedSql generatedSql = ((JdbcQueryGeneratorResult)result.get()).getGeneratedSql();
            if (!generatedSql.isPushDown()) {
                return Optional.empty();
            }
            JdbcQueryGeneratorContext.GroupIdNodeInfo groupIdNodeInfo = context.getGroupIdNodeInfo();
            String sql = generatedSql.getSql();
            if (groupIdNodeInfo.isGroupByComplexOperation()) {
                sql = JdbcPlanOptimizerUtils.replaceGroupingSetColumns((String)sql);
            }
            if ((long)sql.getBytes(StandardCharsets.ISO_8859_1).length >= DataCenterPlanOptimizer.this.config.getRemoteHttpServerMaxRequestHeaderSize().toBytes()) {
                log.debug("Generated sql is too long, push down failed.");
                return Optional.empty();
            }
            try {
                columnsList = DataCenterPlanOptimizer.this.client.getColumns(sql);
            }
            catch (PrestoException e) {
                log.warn("query push down failed for [%s]", new Object[]{e.getMessage()});
                return Optional.empty();
            }
            if (columnsList.isEmpty()) {
                log.debug("Get columns from generated sql failed.");
                return Optional.empty();
            }
            HashMap columns = new HashMap();
            IntStream.range(0, columnsList.size()).forEach(i -> {
                DataCenterColumn column = (DataCenterColumn)columnsList.get(i);
                columns.put(column.getName(), new DataCenterColumnHandle(column.getName(), column.getType(), i));
            });
            ImmutableList.Builder scanOutputs = new ImmutableList.Builder();
            ImmutableMap.Builder columnHandles = new ImmutableMap.Builder();
            ImmutableMap.Builder assignments = new ImmutableMap.Builder();
            for (Symbol symbol : node.getOutputSymbols()) {
                Type dcType;
                String aliasName;
                String name = symbol.getName().toLowerCase(Locale.ENGLISH);
                String string = aliasName = groupIdNodeInfo.isGroupByComplexOperation() ? JdbcPlanOptimizerUtils.getGroupingSetColumn((String)name) : name;
                if (!this.types.containsKey(name) || !columns.containsKey(aliasName)) {
                    log.debug("Get type of column [%s] failed", new Object[]{name});
                    return Optional.empty();
                }
                Type prestoType = this.types.get(name);
                if (prestoType.equals(dcType = ((DataCenterColumnHandle)columns.get(aliasName)).getColumnType())) {
                    scanOutputs.add((Object)symbol);
                    columnHandles.put((Object)symbol, columns.get(aliasName));
                    assignments.put((Object)symbol, (Object)new VariableReferenceExpression(symbol.getName(), prestoType));
                    continue;
                }
                if (prestoType instanceof UnknownType) {
                    log.debug("Can't cast from type[%s] to type[%s]", new Object[]{dcType.getDisplayName(), prestoType.getDisplayName()});
                    return Optional.empty();
                }
                Symbol scanSymbol = this.symbolAllocator.newSymbol(symbol.getName(), dcType);
                scanOutputs.add((Object)scanSymbol);
                columnHandles.put((Object)scanSymbol, columns.get(aliasName));
                assignments.put((Object)symbol, (Object)new CallExpression(OperatorType.CAST.name(), DataCenterPlanOptimizer.this.functionResolution.castFunction(prestoType.getTypeSignature(), dcType.getTypeSignature()), prestoType, (List)ImmutableList.of((Object)new VariableReferenceExpression(scanSymbol.getName(), dcType)), Optional.empty()));
            }
            Preconditions.checkState((boolean)context.getCatalogName().isPresent(), (Object)"CatalogName is null");
            Preconditions.checkState((boolean)context.getSchemaTableName().isPresent(), (Object)"schemaTableName is null");
            Preconditions.checkState((boolean)context.getTransaction().isPresent(), (Object)"transaction is null");
            CatalogName catalogName = (CatalogName)context.getCatalogName().get();
            String tableCatalogName = catalogName.getCatalogName().startsWith(DataCenterPlanOptimizer.DATACENTER_CATALOG_PREFIX) ? catalogName.getCatalogName().substring(DataCenterPlanOptimizer.DATACENTER_CATALOG_PREFIX.length()) : catalogName.getCatalogName();
            TableHandle newTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)new DataCenterTableHandle(tableCatalogName, ((SchemaTableName)context.getSchemaTableName().get()).getSchemaName(), ((SchemaTableName)context.getSchemaTableName().get()).getTableName(), OptionalLong.empty(), sql), (ConnectorTransactionHandle)context.getTransaction().get(), Optional.empty());
            return Optional.of(new ProjectNode(this.idAllocator.getNextId(), (PlanNode)new TableScanNode(this.idAllocator.getNextId(), newTableHandle, (List)scanOutputs.build(), (Map)columnHandles.build(), TupleDomain.all(), Optional.empty(), ReuseExchangeOperator.STRATEGY.REUSE_STRATEGY_DEFAULT, new UUID(0L, 0L), Integer.valueOf(0), false), new Assignments((Map)assignments.build())));
        }
    }
}

