/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.MoreObjects;
import io.prestosql.plugin.jdbc.BlockWriteFunction;
import io.prestosql.plugin.jdbc.BooleanWriteFunction;
import io.prestosql.plugin.jdbc.DoubleWriteFunction;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.WriteFunction;
import io.prestosql.plugin.jdbc.WriteNullFunction;
import java.util.Objects;

public final class WriteMapping {
    public static final WriteNullFunction DEFAULT_WRITE_NULL_FUNCTION = (statement, index) -> statement.setObject(index, null);
    private final String dataType;
    private final WriteFunction writeFunction;
    private final WriteNullFunction writeNullFunction;

    public static WriteMapping booleanMapping(String dataType, BooleanWriteFunction writeFunction) {
        return WriteMapping.booleanMapping(dataType, writeFunction, DEFAULT_WRITE_NULL_FUNCTION);
    }

    public static WriteMapping booleanMapping(String dataType, BooleanWriteFunction writeFunction, WriteNullFunction writeNullFunction) {
        return new WriteMapping(dataType, writeFunction, writeNullFunction);
    }

    public static WriteMapping longMapping(String dataType, LongWriteFunction writeFunction) {
        return WriteMapping.longMapping(dataType, writeFunction, DEFAULT_WRITE_NULL_FUNCTION);
    }

    public static WriteMapping longMapping(String dataType, LongWriteFunction writeFunction, WriteNullFunction writeNullFunction) {
        return new WriteMapping(dataType, writeFunction, writeNullFunction);
    }

    public static WriteMapping doubleMapping(String dataType, DoubleWriteFunction writeFunction) {
        return WriteMapping.doubleMapping(dataType, writeFunction, DEFAULT_WRITE_NULL_FUNCTION);
    }

    public static WriteMapping doubleMapping(String dataType, DoubleWriteFunction writeFunction, WriteNullFunction writeNullFunction) {
        return new WriteMapping(dataType, writeFunction, writeNullFunction);
    }

    public static WriteMapping sliceMapping(String dataType, SliceWriteFunction writeFunction) {
        return WriteMapping.sliceMapping(dataType, writeFunction, DEFAULT_WRITE_NULL_FUNCTION);
    }

    public static WriteMapping sliceMapping(String dataType, SliceWriteFunction writeFunction, WriteNullFunction writeNullFunction) {
        return new WriteMapping(dataType, writeFunction, writeNullFunction);
    }

    public static WriteMapping blockMapping(String dataType, BlockWriteFunction writeFunction) {
        return WriteMapping.blockMapping(dataType, writeFunction, DEFAULT_WRITE_NULL_FUNCTION);
    }

    public static WriteMapping blockMapping(String dataType, BlockWriteFunction writeFunction, WriteNullFunction defaultWriteNullFunction) {
        return new WriteMapping(dataType, writeFunction, defaultWriteNullFunction);
    }

    private WriteMapping(String dataType, WriteFunction writeFunction, WriteNullFunction writeNullFunction) {
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.writeFunction = Objects.requireNonNull(writeFunction, "writeFunction is null");
        this.writeNullFunction = Objects.requireNonNull(writeNullFunction, "writeNullFunction is null");
    }

    public String getDataType() {
        return this.dataType;
    }

    public WriteFunction getWriteFunction() {
        return this.writeFunction;
    }

    public WriteNullFunction getWriteNullFunction() {
        return this.writeNullFunction;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dataType", (Object)this.dataType).toString();
    }
}

