/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public final class JdbcTypeHandle {
    private final int jdbcType;
    private final Optional<String> jdbcTypeName;
    private final int columnSize;
    private final int decimalDigits;
    private final Optional<Integer> arrayDimensions;

    @JsonCreator
    public JdbcTypeHandle(@JsonProperty(value="jdbcType") int jdbcType, @JsonProperty(value="jdbcTypeName") Optional<String> jdbcTypeName, @JsonProperty(value="columnSize") int columnSize, @JsonProperty(value="decimalDigits") int decimalDigits, @JsonProperty(value="arrayDimensions") Optional<Integer> arrayDimensions) {
        this.jdbcType = jdbcType;
        this.jdbcTypeName = Objects.requireNonNull(jdbcTypeName, "jdbcTypeName is null");
        this.columnSize = columnSize;
        this.decimalDigits = decimalDigits;
        this.arrayDimensions = Objects.requireNonNull(arrayDimensions, "arrayDimensions is null");
    }

    @JsonProperty
    public int getJdbcType() {
        return this.jdbcType;
    }

    @JsonProperty
    public Optional<String> getJdbcTypeName() {
        return this.jdbcTypeName;
    }

    @JsonProperty
    public int getColumnSize() {
        return this.columnSize;
    }

    @JsonProperty
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    @JsonProperty
    public Optional<Integer> getArrayDimensions() {
        return this.arrayDimensions;
    }

    public int hashCode() {
        return Objects.hash(this.jdbcType, this.jdbcTypeName, this.columnSize, this.decimalDigits, this.arrayDimensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcTypeHandle that = (JdbcTypeHandle)o;
        return this.jdbcType == that.jdbcType && this.columnSize == that.columnSize && this.decimalDigits == that.decimalDigits && Objects.equals(this.jdbcTypeName, that.jdbcTypeName) && Objects.equals(this.arrayDimensions, that.arrayDimensions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("jdbcType", this.jdbcType).add("jdbcTypeName", this.jdbcTypeName.orElse(null)).add("columnSize", this.columnSize).add("decimalDigits", this.decimalDigits).add("arrayDimensions", this.arrayDimensions.orElse(null)).toString();
    }
}

