/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorResult;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;

public class JdbcTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final TupleDomain<ColumnHandle> constraint;
    private final OptionalLong limit;
    private final Optional<JdbcQueryGeneratorResult.GeneratedSql> generatedSql;
    private boolean deleteOrUpdate;
    private List<Type> updatedColumnTypes;

    public JdbcTableHandle(SchemaTableName schemaTableName, @Nullable String catalogName, @Nullable String schemaName, String tableName) {
        this(schemaTableName, catalogName, schemaName, tableName, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty());
    }

    public JdbcTableHandle(SchemaTableName schemaTableName, @Nullable String catalogName, @Nullable String schemaName, String tableName, TupleDomain<ColumnHandle> constraint, OptionalLong limit) {
        this(schemaTableName, catalogName, schemaName, tableName, constraint, limit, Optional.empty(), false, null);
    }

    public JdbcTableHandle(SchemaTableName schemaTableName, @Nullable String catalogName, @Nullable String schemaName, String tableName, TupleDomain<ColumnHandle> constraint, OptionalLong limit, Optional<JdbcQueryGeneratorResult.GeneratedSql> generatedSql, boolean deleteOrUpdate) {
        this(schemaTableName, catalogName, schemaName, tableName, constraint, limit, generatedSql, deleteOrUpdate, null);
    }

    @JsonCreator
    public JdbcTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="sql") Optional<JdbcQueryGeneratorResult.GeneratedSql> generatedSql, @JsonProperty(value="deleteOrUpdate") boolean deleteOrUpdate, @JsonProperty(value="updatedColumnTypes") @Nullable List<Type> updatedColumnTypes) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.generatedSql = generatedSql;
        this.deleteOrUpdate = deleteOrUpdate;
        this.updatedColumnTypes = updatedColumnTypes;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<JdbcQueryGeneratorResult.GeneratedSql> getGeneratedSql() {
        return this.generatedSql;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public Boolean getDeleteOrUpdate() {
        return this.deleteOrUpdate;
    }

    public void setDeleteOrUpdate(boolean deleteOrUpdate) {
        this.deleteOrUpdate = deleteOrUpdate;
    }

    @JsonProperty
    @Nullable
    public List<Type> getUpdatedColumnTypes() {
        return this.updatedColumnTypes;
    }

    public void setUpdatedColumnTypes(List<Type> updatedColumnTypes) {
        this.updatedColumnTypes = updatedColumnTypes;
    }

    public String getSchemaPrefixedTableName() {
        return this.schemaTableName.toString();
    }

    public ConnectorTableHandle createFrom(ConnectorTableHandle oldConnectorTableHandle) {
        JdbcTableHandle oldJdbcTableHandle = (JdbcTableHandle)oldConnectorTableHandle;
        return new JdbcTableHandle(this.schemaTableName, this.catalogName, this.schemaName, this.tableName, oldJdbcTableHandle.getConstraint(), oldJdbcTableHandle.getLimit(), oldJdbcTableHandle.getGeneratedSql(), oldJdbcTableHandle.getDeleteOrUpdate(), oldJdbcTableHandle.getUpdatedColumnTypes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcTableHandle o = (JdbcTableHandle)obj;
        return Objects.equals(this.schemaTableName, o.schemaTableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.generatedSql.isPresent()) {
            Joiner.on((String)".").skipNulls().appendTo(builder, (Object)this.catalogName, (Object)this.generatedSql.get(), new Object[0]);
        } else {
            Joiner.on((String)".").skipNulls().appendTo(builder, (Object)this.catalogName, (Object)this.schemaName, new Object[]{this.tableName});
        }
        this.limit.ifPresent(value -> builder.append(" limit=").append(value));
        return builder.toString();
    }
}

