/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.configmanager;

import com.google.common.collect.ImmutableMap;
import io.prestosql.configmanager.ConfigSupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultUdfRewriteConfigSupplier
implements ConfigSupplier {
    private final Map<String, String> udfConfigMap;

    public DefaultUdfRewriteConfigSupplier(Map<String, String> udfConfigMap) {
        Objects.requireNonNull(udfConfigMap);
        this.udfConfigMap = new HashMap<String, String>(udfConfigMap);
    }

    @Override
    public Map<String, String> getConfigKeyValueMap() {
        return ImmutableMap.copyOf(this.udfConfigMap);
    }

    @Override
    public Optional<String> getConfigValue(String key) {
        if (this.udfConfigMap.containsKey(key)) {
            return Optional.of(this.udfConfigMap.get(key));
        }
        return Optional.empty();
    }
}

