/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecialCommentFormatter {
    private static Map<String, String[]> queryMap = new HashMap<String, String[]>();
    private static final String SPECIALREGEX = "^.*/\\*\\s*#distinct@\\s*(\\p{Alnum}+\\s*=\\s*(\\p{Alnum}+)(\\s*,\\s*\\p{Alnum}+)*)*\\s*#\\s*\\*/.*$";
    private static Pattern specialCommentTemplate = Pattern.compile("^.*/\\*\\s*#distinct@\\s*(\\p{Alnum}+\\s*=\\s*(\\p{Alnum}+)(\\s*,\\s*\\p{Alnum}+)*)*\\s*#\\s*\\*/.*$", 8);

    private SpecialCommentFormatter() {
    }

    public static void verifyAndSetTableDistinctColumns(String sql) {
        Matcher matcher = specialCommentTemplate.matcher(sql);
        if (matcher.matches()) {
            SpecialCommentFormatter.insertIntoTableColumnMap(SpecialCommentFormatter.extractSpecialComment(sql));
        }
    }

    private static String extractSpecialComment(String sql) {
        return sql.substring(sql.indexOf("@") + 1, sql.lastIndexOf("#"));
    }

    private static void insertIntoTableColumnMap(String comment) {
        if (!queryMap.isEmpty()) {
            queryMap.clear();
        }
        comment = comment.replaceAll("\\s", "");
        String[] tableAndColumns = comment.split("=");
        String[] columns = tableAndColumns[1].split(",");
        queryMap.put(tableAndColumns[0], columns);
    }

    public static Map<String, String[]> getUniqueColumnTableMap() {
        return queryMap;
    }
}

