/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import io.prestosql.sql.tree.Identifier;
import java.util.Objects;

public class PrincipalSpecification {
    private final Type type;
    private final Identifier name;

    public PrincipalSpecification(Type type, Identifier name) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Type getType() {
        return this.type;
    }

    public Identifier getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrincipalSpecification that = (PrincipalSpecification)o;
        return this.type == that.type && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).toString();
    }

    public static enum Type {
        UNSPECIFIED,
        USER,
        ROLE;

    }
}

