/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class PathElement
extends Node {
    private final Optional<Identifier> catalog;
    private final Identifier schema;

    public PathElement(NodeLocation location, Identifier schema) {
        this(Optional.of(location), Optional.empty(), schema);
    }

    @VisibleForTesting
    public PathElement(Optional<Identifier> catalog, Identifier schema) {
        this(Optional.empty(), catalog, schema);
    }

    public PathElement(NodeLocation location, Identifier catalog, Identifier schema) {
        this(Optional.of(location), Optional.of(catalog), schema);
    }

    private PathElement(Optional<NodeLocation> location, Optional<Identifier> catalog, Identifier schema) {
        super(location);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    public Identifier getSchema() {
        return this.schema;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPathElement(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement o = (PathElement)obj;
        return Objects.equals(this.schema, o.schema) && Objects.equals(this.catalog, o.catalog);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.schema);
    }

    @Override
    public String toString() {
        if (this.catalog.isPresent()) {
            return String.format("%s.%s", this.catalog.get().toString(), this.schema.toString());
        }
        return this.schema.toString();
    }
}

