/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.sql.expression.Types;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FrameBound
extends Node {
    private final Types.FrameBoundType type;
    private final Optional<Expression> value;

    public FrameBound(Types.FrameBoundType type) {
        this(Optional.empty(), type);
    }

    public FrameBound(NodeLocation location, Types.FrameBoundType type) {
        this(Optional.of(location), type);
    }

    public FrameBound(Types.FrameBoundType type, Expression value) {
        this(Optional.empty(), type, value);
    }

    private FrameBound(Optional<NodeLocation> location, Types.FrameBoundType type) {
        this(location, type, null);
    }

    public FrameBound(NodeLocation location, Types.FrameBoundType type, Expression value) {
        this(Optional.of(location), type, value);
    }

    private FrameBound(Optional<NodeLocation> location, Types.FrameBoundType type, Expression value) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = Optional.ofNullable(value);
    }

    public Types.FrameBoundType getType() {
        return this.type;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFrameBound(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.value.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameBound o = (FrameBound)obj;
        return Objects.equals(this.type, o.type) && Objects.equals(this.value, o.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("value", this.value).toString();
    }
}

