/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.RoutineBody;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExternalBodyReference
extends RoutineBody {
    private final Optional<Identifier> identifier;

    public ExternalBodyReference() {
        this(Optional.empty(), Optional.empty());
    }

    public ExternalBodyReference(Identifier identifier) {
        this(Optional.empty(), Optional.of(identifier));
    }

    private ExternalBodyReference(Optional<NodeLocation> location, Optional<Identifier> identifier) {
        super(location);
        this.identifier = Objects.requireNonNull(identifier, "identifier is null");
    }

    public Optional<Identifier> getIdentifier() {
        return this.identifier;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExternalBodyReference(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        if (this.identifier.isPresent()) {
            return ImmutableList.of((Object)this.identifier.get());
        }
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalBodyReference o = (ExternalBodyReference)obj;
        return Objects.equals(this.identifier, o.identifier);
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        this.identifier.ifPresent(value -> helper.add("identifier", value));
        return helper.toString();
    }
}

