/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropIndex
extends Statement {
    private final QualifiedName indexName;
    private final boolean exists;
    private final Optional<Expression> where;

    public DropIndex(QualifiedName indexName, boolean exists) {
        this(Optional.empty(), indexName, exists, Optional.empty());
    }

    public DropIndex(NodeLocation location, QualifiedName indexName, boolean exists, Optional<Expression> where) {
        this(Optional.of(location), indexName, exists, where);
    }

    private DropIndex(Optional<NodeLocation> location, QualifiedName indexName, boolean exists, Optional<Expression> where) {
        super(location);
        this.indexName = indexName;
        this.exists = exists;
        this.where = where;
    }

    public QualifiedName getIndexName() {
        return this.indexName;
    }

    public boolean exists() {
        return this.exists;
    }

    public Optional<Expression> getPartitions() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropIndex(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropIndex o = (DropIndex)obj;
        return Objects.equals(this.indexName, o.indexName) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexName", (Object)this.indexName).add("exists", this.exists).toString();
    }
}

