/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.FunctionProperty;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.RoutineBody;
import io.prestosql.sql.tree.RoutineCharacteristics;
import io.prestosql.sql.tree.SqlParameterDeclaration;
import io.prestosql.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateFunction
extends Statement {
    private final QualifiedName functionName;
    private final boolean replace;
    private final List<SqlParameterDeclaration> parameters;
    private final String returnType;
    private final Optional<String> comment;
    private final RoutineCharacteristics characteristics;
    private final RoutineBody body;
    private final List<FunctionProperty> properties;

    public CreateFunction(QualifiedName functionName, boolean replace, List<SqlParameterDeclaration> parameters, String returnType, Optional<String> comment, RoutineCharacteristics characteristics, RoutineBody body, List<FunctionProperty> properties) {
        this(Optional.empty(), replace, functionName, parameters, returnType, comment, characteristics, body, properties);
    }

    public CreateFunction(NodeLocation location, boolean replace, QualifiedName functionName, List<SqlParameterDeclaration> parameters, String returnType, Optional<String> comment, RoutineCharacteristics characteristics, RoutineBody body, List<FunctionProperty> properties) {
        this(Optional.of(location), replace, functionName, parameters, returnType, comment, characteristics, body, properties);
    }

    private CreateFunction(Optional<NodeLocation> location, boolean replace, QualifiedName functionName, List<SqlParameterDeclaration> parameters, String returnType, Optional<String> comment, RoutineCharacteristics characteristics, RoutineBody body, List<FunctionProperty> properties) {
        super(location);
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.replace = replace;
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.characteristics = Objects.requireNonNull(characteristics, "routineCharacteristics is null");
        this.body = Objects.requireNonNull(body, "body is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
    }

    public QualifiedName getFunctionName() {
        return this.functionName;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public List<SqlParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public RoutineCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    public RoutineBody getBody() {
        return this.body;
    }

    public List<FunctionProperty> getFunctionProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.body).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.parameters, this.returnType, this.comment, this.characteristics, this.body, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateFunction o = (CreateFunction)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.parameters, o.parameters) && Objects.equals(this.returnType, o.returnType) && Objects.equals(this.comment, o.comment) && Objects.equals(this.characteristics, o.characteristics) && Objects.equals(this.body, o.body) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("parameters", this.parameters).add("returnType", (Object)this.returnType).add("comment", this.comment).add("characteristics", (Object)this.characteristics).add("body", (Object)this.body).add("properties", this.properties).toString();
    }
}

