/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TimeStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JmxGcMonitor
implements GcMonitor {
    private final Logger log = Logger.get(JmxGcMonitor.class);
    private final NotificationListener notificationListener = (notification, ignored) -> this.onNotification(notification);
    private final AtomicLong majorGcCount = new AtomicLong();
    private final AtomicLong majorGcTime = new AtomicLong();
    private final TimeStat majorGc = new TimeStat();
    private final TimeStat minorGc = new TimeStat();
    @GuardedBy(value="this")
    private long lastGcEndTime = System.currentTimeMillis();

    @PostConstruct
    public void start() {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ObjectName objectName = mbean.getObjectName();
            try {
                ManagementFactory.getPlatformMBeanServer().addNotificationListener(objectName, this.notificationListener, null, null);
            }
            catch (JMException e) {
                throw new RuntimeException("Unable to add GC listener", e);
            }
        }
    }

    @PreDestroy
    public void stop() {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ObjectName objectName = mbean.getObjectName();
            try {
                ManagementFactory.getPlatformMBeanServer().removeNotificationListener(objectName, this.notificationListener);
            }
            catch (JMException jMException) {}
        }
    }

    @Override
    public long getMajorGcCount() {
        return this.majorGcCount.get();
    }

    @Override
    public Duration getMajorGcTime() {
        return new Duration((double)this.majorGcTime.get(), TimeUnit.MILLISECONDS);
    }

    @Managed
    @Nested
    public TimeStat getMajorGc() {
        return this.majorGc;
    }

    @Managed
    @Nested
    public TimeStat getMinorGc() {
        return this.minorGc;
    }

    private synchronized void onNotification(Notification notification) {
        if ("com.sun.management.gc.notification".equals(notification.getType())) {
            GarbageCollectionNotificationInfo info = new GarbageCollectionNotificationInfo((CompositeData)notification.getUserData());
            if (info.isMajorGc()) {
                this.majorGcCount.incrementAndGet();
                this.majorGcTime.addAndGet(info.getDurationMs());
                this.majorGc.add(info.getDurationMs(), TimeUnit.MILLISECONDS);
                long applicationRuntime = Math.max(0L, info.getStartTime() - this.lastGcEndTime);
                this.lastGcEndTime = info.getEndTime();
                this.log.info("Major GC: application %sms, stopped %sms: %s -> %s", new Object[]{applicationRuntime, info.getDurationMs(), info.getBeforeGcTotal(), info.getAfterGcTotal()});
            } else if (info.isMinorGc()) {
                this.minorGc.add(info.getDurationMs(), TimeUnit.MILLISECONDS);
                this.log.debug("Minor GC: duration %sms: %s -> %s", new Object[]{info.getDurationMs(), info.getBeforeGcTotal(), info.getAfterGcTotal()});
            }
        }
    }

    private static class GarbageCollectionNotificationInfo {
        private static final String MINOR_GC_NAME = "end of minor GC";
        private static final String MAJOR_GC_NAME = "end of major GC";
        private final String gcName;
        private final String gcAction;
        private final String gcCause;
        private final long startTime;
        private final long endTime;
        private final Map<String, MemoryUsage> usageBeforeGc;
        private final Map<String, MemoryUsage> usageAfterGc;

        GarbageCollectionNotificationInfo(CompositeData compositeData) {
            Objects.requireNonNull(compositeData, "compositeData is null");
            this.gcName = (String)compositeData.get("gcName");
            this.gcAction = (String)compositeData.get("gcAction");
            this.gcCause = (String)compositeData.get("gcCause");
            CompositeData gcInfo = (CompositeData)compositeData.get("gcInfo");
            this.startTime = (Long)gcInfo.get("startTime");
            this.endTime = (Long)gcInfo.get("endTime");
            this.usageBeforeGc = GarbageCollectionNotificationInfo.extractMemoryUsageMap(gcInfo, "memoryUsageBeforeGc");
            this.usageAfterGc = GarbageCollectionNotificationInfo.extractMemoryUsageMap(gcInfo, "memoryUsageAfterGc");
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getDurationMs() {
            return Math.max(0L, this.endTime - this.startTime);
        }

        public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
            return this.usageBeforeGc;
        }

        public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
            return this.usageAfterGc;
        }

        private DataSize getBeforeGcTotal() {
            return GarbageCollectionNotificationInfo.totalMemorySize(this.getMemoryUsageBeforeGc());
        }

        private DataSize getAfterGcTotal() {
            return GarbageCollectionNotificationInfo.totalMemorySize(this.getMemoryUsageAfterGc());
        }

        public boolean isMinorGc() {
            return this.gcAction.equalsIgnoreCase(MINOR_GC_NAME);
        }

        public boolean isMajorGc() {
            return this.gcAction.equalsIgnoreCase(MAJOR_GC_NAME);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("gcName", (Object)this.gcName).add("gcAction", (Object)this.gcAction).add("gcCause", (Object)this.gcCause).add("durationMs", this.getDurationMs()).add("beforeGcMb", (Object)this.getBeforeGcTotal()).add("afterGcMb", (Object)this.getAfterGcTotal()).toString();
        }

        private static DataSize totalMemorySize(Map<String, MemoryUsage> memUsages) {
            long bytes = 0L;
            for (MemoryUsage memoryUsage : memUsages.values()) {
                bytes += memoryUsage.getUsed();
            }
            return DataSize.succinctBytes((long)bytes);
        }

        private static Map<String, MemoryUsage> extractMemoryUsageMap(CompositeData compositeData, String attributeName) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            TabularData tabularData = (TabularData)compositeData.get(attributeName);
            for (CompositeData entry : tabularData.values()) {
                map.put((Object)((String)entry.get("key")), (Object)MemoryUsage.from((CompositeData)entry.get("value")));
            }
            return map.build();
        }
    }
}

