/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.functioncall;

import io.prestosql.sql.builder.functioncall.BaseFunctionUtil;
import io.prestosql.sql.builder.functioncall.FunctionCallArgsPackage;
import java.util.Locale;

public class ConfigFunctionParser {
    private ConfigFunctionParser() {
    }

    public static String baseConfigPropertyValueToFunctionPushDownString(FunctionCallArgsPackage functionCallArgsPackage, String functionPropertyValue) {
        int numArgs = functionCallArgsPackage.getArgumentsList().size();
        String resultString = functionPropertyValue;
        for (int i = 0; i < numArgs; ++i) {
            String arg1 = String.format("$%d", i + 1);
            resultString = resultString.replace(arg1, functionCallArgsPackage.getArgumentsList().get(i));
        }
        return resultString;
    }

    public static String baseFunctionArgsToConfigPropertyName(FunctionCallArgsPackage functionCallArgsPackage) {
        String functionName = BaseFunctionUtil.formatQualifiedName(functionCallArgsPackage.getName()).toUpperCase(Locale.ENGLISH);
        StringBuilder funcSignatureSb = new StringBuilder(functionName);
        funcSignatureSb.append("(");
        for (int i = 0; i < functionCallArgsPackage.getArgumentsList().size(); ++i) {
            funcSignatureSb.append(String.format("$%d", i + 1));
            if (i == functionCallArgsPackage.getArgumentsList().size() - 1) continue;
            funcSignatureSb.append(",");
        }
        return funcSignatureSb.append(")").toString();
    }
}

