/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc.optimization;

import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.plan.AggregationNode;
import io.prestosql.spi.plan.FilterNode;
import io.prestosql.spi.plan.LimitNode;
import io.prestosql.spi.plan.PlanNode;
import io.prestosql.spi.plan.ProjectNode;
import io.prestosql.spi.plan.TableScanNode;
import io.prestosql.spi.plan.TopNNode;
import java.util.Set;

public enum JdbcPushDownModule {
    DEFAULT,
    FULL_PUSHDOWN,
    BASE_PUSHDOWN;

    private static final Set<Class<? extends PlanNode>> BASE_PUSH_DOWN_NODE;

    public boolean isAvailable(PlanNode node) {
        switch (this) {
            case FULL_PUSHDOWN: {
                return true;
            }
            case BASE_PUSHDOWN: {
                return BASE_PUSH_DOWN_NODE.contains(node.getClass());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported push down module");
    }

    static {
        BASE_PUSH_DOWN_NODE = ImmutableSet.of(FilterNode.class, AggregationNode.class, LimitNode.class, TopNNode.class, ProjectNode.class, TableScanNode.class, (Object[])new Class[0]);
    }
}

