/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcMetadata;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.JdbcMetadataFactory;
import io.prestosql.plugin.jdbc.JdbcPageSinkProvider;
import io.prestosql.plugin.jdbc.JdbcPageSourceProvider;
import io.prestosql.plugin.jdbc.JdbcSplitManager;
import io.prestosql.plugin.jdbc.JdbcTransactionHandle;
import io.prestosql.plugin.jdbc.optimization.JdbcPlanOptimizer;
import io.prestosql.plugin.jdbc.optimization.JdbcPlanOptimizerProvider;
import io.prestosql.spi.ConnectorPlanOptimizer;
import io.prestosql.spi.connector.CachedConnectorMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorCapabilities;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorPlanOptimizerProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.function.ExternalFunctionHub;
import io.prestosql.spi.function.FunctionMetadataManager;
import io.prestosql.spi.function.StandardFunctionResolution;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.relation.RowExpressionService;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class JdbcConnector
implements Connector {
    private static final Logger log = Logger.get(JdbcConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final JdbcMetadataFactory jdbcMetadataFactory;
    private final JdbcSplitManager jdbcSplitManager;
    private final JdbcPageSourceProvider jdbcPageSourceProvider;
    private final JdbcPageSinkProvider jdbcPageSinkProvider;
    private final Optional<ConnectorAccessControl> accessControl;
    private final Set<Procedure> procedures;
    private final JdbcMetadataConfig config;
    private final ConnectorPlanOptimizer planOptimizer;
    private final FunctionMetadataManager functionManager;
    private final StandardFunctionResolution functionResolution;
    private final RowExpressionService rowExpressionService;
    private final ConcurrentMap<ConnectorTransactionHandle, JdbcMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, JdbcMetadata>();
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcConnector(LifeCycleManager lifeCycleManager, JdbcMetadataFactory jdbcMetadataFactory, JdbcSplitManager jdbcSplitManager, JdbcPageSourceProvider jdbcPageSourceProvider, JdbcPageSinkProvider jdbcPageSinkProvider, Optional<ConnectorAccessControl> accessControl, Set<Procedure> procedures, FunctionMetadataManager functionManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JdbcMetadataConfig config, JdbcPlanOptimizer planOptimizer, JdbcClient jdbcClient) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.jdbcMetadataFactory = Objects.requireNonNull(jdbcMetadataFactory, "jdbcMetadataFactory is null");
        this.jdbcSplitManager = Objects.requireNonNull(jdbcSplitManager, "jdbcSplitManager is null");
        this.jdbcPageSourceProvider = Objects.requireNonNull(jdbcPageSourceProvider, "jdbcPageSinkProvider is null");
        this.jdbcPageSinkProvider = Objects.requireNonNull(jdbcPageSinkProvider, "jdbcPageSinkProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.config = config;
        this.planOptimizer = planOptimizer;
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    public Optional<ExternalFunctionHub> getExternalFunctionHub() {
        return this.jdbcClient.getExternalFunctionHub();
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return new JdbcPlanOptimizerProvider(this.planOptimizer);
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        JdbcTransactionHandle transaction = new JdbcTransactionHandle();
        this.transactions.put(transaction, this.jdbcMetadataFactory.create());
        return transaction;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        JdbcMetadata metadata = (JdbcMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        if (this.config.isMetadataCacheEnabled()) {
            return new CachedConnectorMetadata((ConnectorMetadata)metadata, this.config.getMetadataCacheTtl(), this.config.getMetadataCacheMaximumSize());
        }
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        JdbcMetadata metadata = (JdbcMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.jdbcSplitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.jdbcPageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.jdbcPageSinkProvider;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Sets.immutableEnumSet((Enum)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT, (Enum[])new ConnectorCapabilities[0]);
    }

    public Collection<String> getCatalogs(String user, Map<String, String> extraCredentials) {
        return this.jdbcMetadataFactory.getJdbcClient().getCatalogNames(new JdbcIdentity(user, extraCredentials));
    }
}

