/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.airlift.slice.Slice;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.jdbc.optimization.JdbcConverterContext;
import io.prestosql.plugin.jdbc.optimization.JdbcQueryGeneratorResult;
import io.prestosql.plugin.splitmanager.SplitStatLog;
import io.prestosql.plugin.splitmanager.TableSplitConfig;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.function.ExternalFunctionHub;
import io.prestosql.spi.function.FunctionMetadataManager;
import io.prestosql.spi.function.StandardFunctionResolution;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.relation.DeterminismEvaluator;
import io.prestosql.spi.relation.RowExpressionService;
import io.prestosql.spi.sql.QueryGenerator;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public interface JdbcClient {
    default public boolean schemaExists(JdbcIdentity identity, String schema) {
        return this.getSchemaNames(identity).contains(schema);
    }

    public String getIdentifierQuote();

    public Set<String> getSchemaNames(JdbcIdentity var1);

    public List<SchemaTableName> getTableNames(JdbcIdentity var1, Optional<String> var2);

    public Optional<JdbcTableHandle> getTableHandle(JdbcIdentity var1, SchemaTableName var2);

    public List<JdbcColumnHandle> getColumns(ConnectorSession var1, JdbcTableHandle var2);

    public Optional<ColumnMapping> toPrestoType(ConnectorSession var1, Connection var2, JdbcTypeHandle var3);

    public WriteMapping toWriteMapping(ConnectorSession var1, Type var2);

    public ConnectorSplitSource getSplits(JdbcIdentity var1, JdbcTableHandle var2);

    public Connection getConnection(JdbcIdentity var1, JdbcSplit var2) throws SQLException;

    default public void abortReadConnection(Connection connection) throws SQLException {
    }

    public PreparedStatement buildSql(ConnectorSession var1, Connection var2, JdbcSplit var3, JdbcTableHandle var4, List<JdbcColumnHandle> var5) throws SQLException;

    public boolean supportsLimit();

    public boolean isLimitGuaranteed();

    public void addColumn(ConnectorSession var1, JdbcTableHandle var2, ColumnMetadata var3);

    public void dropColumn(JdbcIdentity var1, JdbcTableHandle var2, JdbcColumnHandle var3);

    public void renameColumn(JdbcIdentity var1, JdbcTableHandle var2, JdbcColumnHandle var3, String var4);

    public void renameTable(JdbcIdentity var1, JdbcTableHandle var2, SchemaTableName var3);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void finishInsertTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public void dropTable(JdbcIdentity var1, JdbcTableHandle var2);

    public void rollbackCreateTable(JdbcIdentity var1, JdbcOutputTableHandle var2);

    public String buildInsertSql(JdbcOutputTableHandle var1);

    public Connection getConnection(JdbcIdentity var1, JdbcOutputTableHandle var2) throws SQLException;

    public PreparedStatement getPreparedStatement(Connection var1, String var2) throws SQLException;

    public TableStatistics getTableStatistics(ConnectorSession var1, JdbcTableHandle var2, TupleDomain<ColumnHandle> var3);

    default public Collection<String> getCatalogNames(JdbcIdentity identity) {
        return Collections.emptyList();
    }

    default public Map<String, ColumnHandle> getColumns(ConnectorSession session, String sql, Map<String, Type> types) {
        return Collections.emptyMap();
    }

    default public Optional<QueryGenerator<JdbcQueryGeneratorResult, JdbcConverterContext>> getQueryGenerator(DeterminismEvaluator determinismEvaluator, RowExpressionService rowExpressionService, FunctionMetadataManager functionManager, StandardFunctionResolution functionResolution) {
        return Optional.empty();
    }

    default public boolean isExecutionPlanCacheSupported() {
        return true;
    }

    default public Optional<ExternalFunctionHub> getExternalFunctionHub() {
        return Optional.empty();
    }

    default public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support updates or deletes");
    }

    default public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.empty();
    }

    default public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return OptionalLong.empty();
    }

    default public OptionalLong executeUpdate(ConnectorSession session, ConnectorTableHandle handle) {
        return OptionalLong.empty();
    }

    default public OptionalLong deleteTable(ConnectorSession session, ConnectorTableHandle handle) {
        return OptionalLong.empty();
    }

    default public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support beginDelete");
    }

    default public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support finishDelete");
    }

    default public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<Type> updatedColumnTypes) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support beginDelete");
    }

    default public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support finishUpdate");
    }

    default public String buildDeleteSql(ConnectorTableHandle handle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support buildDeleteSql");
    }

    default public String buildUpdateSql(ConnectorTableHandle handle, int setNum, List<String> updatedColumns) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support buildUpdateSql");
    }

    default public void setDeleteSql(PreparedStatement statement, Block rowIds, int position) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setDeleteSql");
    }

    default public void setUpdateSql(ConnectorSession session, ConnectorTableHandle tableHandle, PreparedStatement statement, List<Block> columnValueAndRowIdBlock, int position, List<String> updatedColumns) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setUpdateSql");
    }

    default public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support updates or deletes");
    }

    default public List<SplitStatLog> getSplitStatic(JdbcIdentity identity, List<JdbcSplit> jdbcSplitList) {
        return Collections.emptyList();
    }

    default public Long[] getSplitFieldMinAndMaxValue(TableSplitConfig conf, Connection connection, JdbcTableHandle tableHandle) {
        return null;
    }
}

