/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Limit
extends Node {
    private final String limit;

    public Limit(String limit) {
        this(Optional.empty(), limit);
    }

    public Limit(NodeLocation location, String limit) {
        this(Optional.of(location), limit);
    }

    public Limit(Optional<NodeLocation> location, String limit) {
        super(location);
        this.limit = limit;
    }

    public String getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limit o = (Limit)obj;
        return Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.limit);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("limit", (Object)this.limit).toString();
    }
}

