/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean replace;
    private final Optional<Security> security;

    public CreateView(QualifiedName name, Query query, boolean replace, Optional<Security> security) {
        this(Optional.empty(), name, query, replace, security);
    }

    public CreateView(NodeLocation location, QualifiedName name, Query query, boolean replace, Optional<Security> security) {
        this(Optional.of(location), name, query, replace, security);
    }

    private CreateView(Optional<NodeLocation> location, QualifiedName name, Query query, boolean replace, Optional<Security> security) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.replace = replace;
        this.security = Objects.requireNonNull(security, "security is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public Optional<Security> getSecurity() {
        return this.security;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.replace, this.security);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateView o = (CreateView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.replace, o.replace) && Objects.equals(this.security, o.security);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("replace", this.replace).add("security", this.security).toString();
    }

    public static enum Security {
        INVOKER,
        DEFINER;

    }
}

