/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Property;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateIndex
extends Statement {
    private final QualifiedName indexName;
    private final QualifiedName tableName;
    private final List<Identifier> columnAliases;
    private final String indexType;
    private final boolean notExists;
    private final List<Property> properties;
    private final Optional<Expression> where;

    public CreateIndex(QualifiedName indexName, QualifiedName tableName, List<Identifier> columnAliases, String indexType, boolean notExists, List<Property> properties) {
        this(Optional.empty(), indexName, tableName, columnAliases, indexType, notExists, properties, Optional.empty());
    }

    public CreateIndex(NodeLocation location, QualifiedName indexName, QualifiedName tableName, List<Identifier> columnAliases, String indexType, boolean notExists, List<Property> properties, Optional<Expression> where) {
        this(Optional.of(location), indexName, tableName, columnAliases, indexType, notExists, properties, where);
    }

    private CreateIndex(Optional<NodeLocation> location, QualifiedName indexName, QualifiedName tableName, List<Identifier> columnAliases, String indexType, boolean notExists, List<Property> properties, Optional<Expression> where) {
        super(location);
        this.indexName = Objects.requireNonNull(indexName, "indexName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnAliases = columnAliases;
        this.indexType = Objects.requireNonNull(indexType, "indexType is null");
        this.notExists = notExists;
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.where = where;
    }

    public QualifiedName getIndexName() {
        return this.indexName;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public List<Identifier> getColumnAliases() {
        return this.columnAliases;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<Expression> getExpression() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateIndex(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.columnAliases).addAll(this.properties).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexName, this.tableName, this.columnAliases, this.indexType, this.notExists, this.properties, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateIndex o = (CreateIndex)obj;
        return Objects.equals(this.indexName, o.indexName) && Objects.equals(this.tableName, o.tableName) && Objects.equals(this.columnAliases, o.columnAliases) && Objects.equals(this.indexType, o.indexType) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexName", (Object)this.indexName).add("tableName", (Object)this.tableName).add("columnAliases", this.columnAliases).add("indexType", (Object)this.indexType).add("notExists", this.notExists).add("properties", this.properties).add("where", this.where).toString();
    }
}

