/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter.client;

import com.google.common.net.HostAndPort;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.prestosql.client.DataCenterClientSession;
import io.prestosql.client.KerberosUtil;
import io.prestosql.client.OkHttpUtil;
import io.prestosql.client.StatementClient;
import io.prestosql.spi.type.TypeManager;
import java.io.File;
import java.net.URI;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;

@Singleton
public class DataCenterStatementClientFactory {
    private static final long KEEP_ALIVE_DURATION = 5L;

    private DataCenterStatementClientFactory() {
    }

    public static DataCenterClientSession createClientSession(DataCenterConfig config, TypeManager typeManager) {
        return DataCenterStatementClientFactory.createClientSession(config, typeManager, Collections.emptyMap());
    }

    public static DataCenterClientSession createClientSession(DataCenterConfig config, TypeManager typeManager, Map<String, String> properties) {
        DataCenterClientSession.Builder builder = DataCenterClientSession.builder((URI)config.getConnectionUrl(), (String)config.getConnectionUser()).withSource(config.getApplicationNamePrefix()).withTimezone(ZoneId.systemDefault()).withLocale(Locale.getDefault()).withClientTimeout(config.getClientTimeout()).withMaxAnticipatedDelay(config.getMaxAnticipatedDelay()).withCompression(config.isCompressionEnabled()).withProperties(properties).withTypeManager(typeManager);
        return builder.build();
    }

    public static DataCenterClientSession createClientSession(StatementClient client, DataCenterConfig config, TypeManager typeManager) {
        DataCenterClientSession.Builder builder = DataCenterClientSession.builder((URI)config.getConnectionUrl(), (String)config.getConnectionUser()).withSource(config.getApplicationNamePrefix()).withLocale(Locale.getDefault()).withClientTimeout(config.getClientTimeout()).withMaxAnticipatedDelay(config.getMaxAnticipatedDelay()).withCompression(config.isCompressionEnabled()).withCatalog((String)client.getSetCatalog().orElse(null)).withSchema((String)client.getSetSchema().orElse(null)).withPath((String)client.getSetPath().orElse(null)).withPreparedStatements(client.getAddedPreparedStatements()).withRoles(client.getSetRoles()).withTransactionId(client.getStartedTransactionId()).withTimezone(client.getTimeZone()).withProperties(client.getSetSessionProperties()).withTypeManager(typeManager);
        return builder.build();
    }

    private static void setupClient(OkHttpClient.Builder builder, DataCenterConfig config) {
        String accessToken;
        boolean isUseSecureConnection = config.isSsl();
        OkHttpUtil.setupCookieJar((OkHttpClient.Builder)builder);
        OkHttpUtil.setupSocksProxy((OkHttpClient.Builder)builder, Optional.ofNullable(config.getSocksProxy() != null ? HostAndPort.fromString((String)config.getSocksProxy()) : null));
        OkHttpUtil.setupHttpProxy((OkHttpClient.Builder)builder, Optional.ofNullable(config.getHttpProxy() != null ? HostAndPort.fromString((String)config.getHttpProxy()) : null));
        String password = config.getConnectionPassword();
        if (password != null && !password.isEmpty()) {
            if (!isUseSecureConnection) {
                throw new RuntimeException("Authentication using username/password requires SSL to be enabled");
            }
            builder.addInterceptor(OkHttpUtil.basicAuth((String)config.getConnectionUser(), (String)password));
        }
        if (isUseSecureConnection) {
            OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, Optional.ofNullable(config.getSslKeyStorePath()), Optional.ofNullable(config.getSslKeyStorePassword()), Optional.ofNullable(config.getSslTrustStorePath()), Optional.ofNullable(config.getSslTrustStorePassword()));
        }
        builder.connectTimeout(config.getHttpRequestConnectTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder.readTimeout(config.getHttpRequestReadTimeout().toMillis(), TimeUnit.MILLISECONDS);
        String kerberosRemoteServiceName = config.getKerberosRemoteServiceName();
        if (kerberosRemoteServiceName != null && !kerberosRemoteServiceName.isEmpty()) {
            if (!isUseSecureConnection) {
                throw new RuntimeException("Authentication using Kerberos requires SSL to be enabled");
            }
            String kerberosCredentialCachePath = config.getKerberosCredentialCachePath() != null ? config.getKerberosCredentialCachePath() : (String)KerberosUtil.defaultCredentialCachePath().orElse(null);
            OkHttpUtil.setupKerberos((OkHttpClient.Builder)builder, (String)config.getKerberosServicePrincipalPattern(), (String)kerberosRemoteServiceName, (boolean)config.isKerberosUseCanonicalHostname(), Optional.ofNullable(config.getKerberosPrincipal()), Optional.ofNullable(config.getKerberosConfigPath() != null ? new File(config.getKerberosConfigPath()) : null), Optional.ofNullable(config.getKerberosKeytabPath() != null ? new File(config.getKerberosKeytabPath()) : null), Optional.ofNullable(kerberosCredentialCachePath != null ? new File(kerberosCredentialCachePath) : null));
        }
        if ((accessToken = config.getAccessToken()) != null && !accessToken.isEmpty()) {
            if (!isUseSecureConnection) {
                throw new RuntimeException("Authentication using an access token requires SSL to be enabled");
            }
            builder.addInterceptor(OkHttpUtil.tokenAuth((String)accessToken));
        }
        builder.connectionPool(new ConnectionPool(config.getMaxIdleConnections(), 5L, TimeUnit.MINUTES));
    }

    public static OkHttpClient newHttpClient(DataCenterConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        DataCenterStatementClientFactory.setupClient(builder, config);
        return builder.build();
    }
}

